api_2023_12 = {
    "__array_api_version__": "2023.12",
    "array object": {
        "operators": {},
        "attributes": {
            "dtype": "Data type of the array elements.",
            "device": "Hardware device the array data resides on.",
            "mT": "Transpose of a matrix (or a stack of matrices).",
            "ndim": "Number of array dimensions (axes).",
            "shape": "Array dimensions.",
            "size": "Number of elements in an array.",
            "T": "Transpose of the array.",
        },
        "methods": {
            "__abs__": "def __abs__(self) -> Array",
            "__add__": "def __add__(self, other: Array) -> Array",
            "__and__": "def __and__(self, other: Array) -> Array",
            "__array_namespace__": "def __array_namespace__(self) -> ModuleType",
            "__bool__": "def __bool__(self) -> bool",
            "__complex__": "def __complex__(self) -> complex",
            "__dlpack__": "def __dlpack__(self, *, stream: Optional[Union[int, Any]] = None) -> PyCapsule",
            "__dlpack_device__": "def __dlpack_device__(self) -> Tuple[enum, int]",
            "__eq__": "def __eq__(self, other: Any) -> bool",
            "__float__": "def __float__(self) -> float",
            "__floordiv__": "def __floordiv__(self, other: Array) -> Array",
            "__ge__": "def __ge__(self, other: Array) -> Array",
            "__getitem__": "def __getitem__(self, key: Union[int, slice, Tuple[Union[int, slice], ...]]) -> Array",
            "__gt__": "def __gt__(self, other: Array) -> Array",
            "__index__": "def __index__(self) -> int",
            "__int__": "def __int__(self) -> int",
            "__invert__": "def __invert__(self) -> Array",
            "__le__": "def __le__(self, other: Array) -> Array",
            "__lshift__": "def __lshift__(self, other: Array) -> Array",
            "__lt__": "def __lt__(self, other: Array) -> Array",
            "__matmul__": "def __matmul__(self, other: Array) -> Array",
            "__mod__": "def __mod__(self, other: Array) -> Array",
            "__mul__": "def __mul__(self, other: Array) -> Array",
            "__ne__": "def __ne__(self, other: Any) -> bool",
            "__neg__": "def __neg__(self) -> Array",
            "__or__": "def __or__(self, other: Array) -> Array",
            "__pos__": "def __pos__(self) -> Array",
            "__pow__": "def __pow__(self, other: Array) -> Array",
            "__rshift__": "def __rshift__(self, other: Array) -> Array",
            "__setitem__": "def __setitem__(self, key: Union[int, slice, Tuple[Union[int, slice], ...]], value: Array) -> None",
            "__sub__": "def __sub__(self, other: Array) -> Array",
            "__truediv__": "def __truediv__(self, other: Array) -> Array",
            "__xor__": "def __xor__(self, other: Array) -> Array",
            "to_device": "def to_device(self, device: Device, /) -> Array",
        },
    },
    "constants": {
        "e": "float",
        "inf": "float",
        "nan": "float",
        "newaxis": "int",
        "pi": "float",
    },
    "creation functions": {
        "arange": "def arange(start: Union[int, float], /, stop: Optional[Union[int, float]] = None, step: Union[int, float] = 1, *, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
        "asarray": "def asarray(obj: Any, /, *, dtype: Optional[Dtype] = None, device: Optional[Device] = None, copy: Optional[bool] = None) -> Array",
        "empty": "def empty(shape: Union[int, Tuple[int, ...]], *, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
        "empty_like": "def empty_like(x: Array, /, *, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
        "eye": "def eye(n_rows: int, n_cols: Optional[int] = None, /, *, k: int = 0, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
        "from_dlpack": "def from_dlpack(x: PyCapsule, /) -> Array",
        "full": "def full(shape: Union[int, Tuple[int, ...]], fill_value: Union[int, float, bool], *, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
        "full_like": "def full_like(x: Array, /, fill_value: Union[int, float, bool], *, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
        "linspace": "def linspace(start: Union[int, float], stop: Union[int, float], num: int, /, *, dtype: Optional[Dtype] = None, device: Optional[Device] = None, endpoint: bool = True) -> Array",
        "meshgrid": "def meshgrid(*arrays: Array, indexing: str = 'xy') -> List[Array]",
        "ones": "def ones(shape: Union[int, Tuple[int, ...]], *, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
        "ones_like": "def ones_like(x: Array, /, *, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
        "tril": "def tril(x: Array, /, *, k: int = 0) -> Array",
        "triu": "def triu(x: Array, /, *, k: int = 0) -> Array",
        "zeros": "def zeros(shape: Union[int, Tuple[int, ...]], *, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
        "zeros_like": "def zeros_like(x: Array, /, *, dtype: Optional[Dtype] = None, device: Optional[Device] = None) -> Array",
    },
    "data type functions": {
        "astype": "def astype(x: Array, dtype: Dtype, /, *, copy: bool = True) -> Array",
        "can_cast": "def can_cast(from_: Dtype, to: Dtype, /) -> bool",
        "finfo": "def finfo(type: Union[Dtype, Array], /) -> finfo_object",
        "iinfo": "def iinfo(type: Union[Dtype, Array], /) -> iinfo_object",
        "isdtype": "def isdtype(dtype: Any, kind: Union[Dtype, Tuple[Dtype, ...]], /) -> bool",
        "result_type": "def result_type(*arrays_and_dtypes: Union[Array, Dtype]) -> Dtype",
    },
    "data types": {
        "bool": "dtype",
        "int8": "dtype",
        "int16": "dtype",
        "int32": "dtype",
        "int64": "dtype",
        "uint8": "dtype",
        "uint16": "dtype",
        "uint32": "dtype",
        "uint64": "dtype",
        "float32": "dtype",
        "float64": "dtype",
        "complex64": "dtype",
        "complex128": "dtype",
        "categories": {
            "numeric": (
                "int8", "int16", "int32", "int64", "uint8", "uint16", "uint32",
                "uint64", "float32", "float64", "complex64", "complex128"
            ),
            "real-valued": (
                "int8", "int16", "int32", "int64", "uint8", "uint16", "uint32",
                "uint64", "float32", "float64"
            ),
            "integer": (
                "int8", "int16", "int32", "int64", "uint8", "uint16", "uint32",
            ),
            "floating-point": (
                "float32", "float64", "complex64", "complex128"
            ),
            "real-valued_floating-point": (
                "float32", "float64"
            ),
            "complex floating-point": (
                "complex64", "complex128"
            ),
            "boolean": ("bool",),
        }
    },
    "element-wise functions": {
        "abs": "def abs(x: Array, /) -> Array",
        "acos": "def acos(x: Array, /) -> Array",
        "acosh": "def acosh(x: Array, /) -> Array",
        "add": "def add(x1: Array, x2: Array, /) -> Array",
        "asin": "def asin(x: Array, /) -> Array",
        "asinh": "def asinh(x: Array, /) -> Array",
        "atan": "def atan(x: Array, /) -> Array",
        "atan2": "def atan2(x1: Array, x2: Array, /) -> Array",
        "atanh": "def atanh(x: Array, /) -> Array",
        "bitwise_and": "def bitwise_and(x1: Array, x2: Array, /) -> Array",
        "bitwise_left_shift": "def bitwise_left_shift(x1: Array, x2: Array, /) -> Array",
        "bitwise_invert": "def bitwise_invert(x: Array, /) -> Array",
        "bitwise_or": "def bitwise_or(x1: Array, x2: Array, /) -> Array",
        "bitwise_right_shift": "def bitwise_right_shift(x1: Array, x2: Array, /) -> Array",
        "bitwise_xor": "def bitwise_xor(x1: Array, x2: Array, /) -> Array",
        "ceil": "def ceil(x: Array, /) -> Array",
        "clip": "def clip(x: Array, x_min: Array, x_max: Array, /) -> Array",
        "conj": "def conj(x: Array, /) -> Array",
        "copysign": "def copysign(x1: Array, x2: Array, /) -> Array",
        "cos": "def cos(x: Array, /) -> Array",
        "cosh": "def cosh(x: Array, /) -> Array",
        "divide": "def divide(x1: Array, x2: Array, /) -> Array",
        "equal": "def equal(x1: Array, x2: Array, /) -> Array",
        "exp": "def exp(x: Array, /) -> Array",
        "expm1": "def expm1(x: Array, /) -> Array",
        "floor": "def floor(x: Array, /) -> Array",
        "floor_divide": "def floor_divide(x1: Array, x2: Array, /) -> Array",
        "greater": "def greater(x1: Array, x2: Array, /) -> Array",
        "greater_equal": "def greater_equal(x1: Array, x2: Array, /) -> Array",
        "hypot": "def hypot(x1: Array, x2: Array, /) -> Array",
        "imag": "def imag(x: Array, /) -> Array",
        "isfinite": "def isfinite(x: Array, /) -> Array",
        "isinf": "def isinf(x: Array, /) -> Array",
        "isnan": "def isnan(x: Array, /) -> Array",
        "less": "def less(x1: Array, x2: Array, /) -> Array",
        "less_equal": "def less_equal(x1: Array, x2: Array, /) -> Array",
        "log": "def log(x: Array, /) -> Array",
        "log1p": "def log1p(x: Array, /) -> Array",
        "log2": "def log2(x: Array, /) -> Array",
        "log10": "def log10(x: Array, /) -> Array",
        "logaddexp": "def logaddexp(x1: Array, x2: Array, /) -> Array",
        "logical_and": "def logical_and(x1: Array, x2: Array, /) -> Array",
        "logical_not": "def logical_not(x: Array, /) -> Array",
        "logical_or": "def logical_or(x1: Array, x2: Array, /) -> Array",
        "logical_xor": "def logical_xor(x1: Array, x2: Array, /) -> Array",
        "maximum": "def maximum(x1: Array, x2: Array, /) -> Array",
        "minimum": "def minimum(x1: Array, x2: Array, /) -> Array",
        "multiply": "def multiply(x1: Array, x2: Array, /) -> Array",
        "negative": "def negative(x: Array, /) -> Array",
        "not_equal": "def not_equal(x1: Array, x2: Array, /) -> Array",
        "positive": "def positive(x: Array, /) -> Array",
        "pow": "def pow(x1: Array, x2: Array, /) -> Array",
        "real": "def real(x: Array, /) -> Array",
        "remainder": "def remainder(x1: Array, x2: Array, /) -> Array",
        "round": "def round(x: Array, /) -> Array",
        "sign": "def sign(x: Array, /) -> Array",
        "signbit": "def signbit(x: Array, /) -> Array",
        "sin": "def sin(x: Array, /) -> Array",
        "sinh": "def sinh(x: Array, /) -> Array",
        "square": "def square(x: Array, /) -> Array",
        "sqrt": "def sqrt(x: Array, /) -> Array",
        "subtract": "def subtract(x1: Array, x2: Array, /) -> Array",
        "tan": "def tan(x: Array, /) -> Array",
        "tanh": "def tanh(x: Array, /) -> Array",
        "trunc": "def trunc(x: Array, /) -> Array",
    },
    "indexing functions": {
        "take": "def take(x: Array, indices: Array, /) -> Array",
    },
    "manipulation functions": {
        "broadcast_arrays": "def broadcast_arrays(*arrays: Array) -> List[Array]",
        "broadcast_to": "def broadcast_to(x: Array, shape: Tuple[int, ...], /) -> Array",
        "concat": "def concat(arrays: List[Array], /, *, axis: int = 0) -> Array",
        "expand_dims": "def expand_dims(x: Array, axis: int, /) -> Array",
        "flip": "def flip(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None) -> Array",
        "moveaxis": "def moveaxis(x: Array, source: Union[int, Tuple[int, ...]], destination: Union[int, Tuple[int, ...]], /) -> Array",
        "permute_dims": "def permute_dims(x: Array, axes: Tuple[int, ...], /) -> Array",
        "repeat": "def repeat(x: Array, repeats: Union[int, Tuple[int, ...]], /, *, axis: Optional[int] = None) -> Array",
        "reshape": "def reshape(x: Array, shape: Tuple[int, ...], /) -> Array",
        "roll": "def roll(x: Array, shift: Union[int, Tuple[int, ...]], /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None) -> Array",
        "squeeze": "def squeeze(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None) -> Array",
        "stack": "def stack(arrays: List[Array], /, *, axis: int = 0) -> Array",
        "tile": "def tile(x: Array, reps: Tuple[int, ...], /) -> Array",
        "unstack": "def unstack(x: Array, /, *, axis: int = 0) -> List[Array]",
    },
    "searching functions": {
        "argmax": "def argmax(x: Array, /, *, axis: Optional[int] = None, keepdims: bool = False) -> Array",
        "argmin": "def argmin(x: Array, /, *, axis: Optional[int] = None, keepdims: bool = False) -> Array",
        "nonzero": "def nonzero(x: Array, /) -> Tuple[Array, ...]",
        "searchsorted": "def searchsorted(x: Array, v: Array, /, *, side: str = 'left', sorter: Optional[Array] = None) -> Array",
        "where": "def where(condition: Array, x1: Array, x2: Array, /) -> Array",
    },
    "set functions": {
        "unique_all": "def unique_all(x: Array, /) -> Tuple[Array, Array, Array, Array]",
        "unique_counts": "def unique_counts(x: Array, /) -> Tuple[Array, Array]",
        "unique_inverse": "def unique_inverse(x: Array, /) -> Tuple[Array, Array]",
        "unique_values": "def unique_values(x: Array, /) -> Array",
    },
    "sorting functions": {
        "argsort": "def argsort(x: Array, /, *, axis: int = -1, descending: bool = False, stable: bool = True) -> Array",
        "sort": "def sort(x: Array, /, *, axis: int = -1, descending: bool = False, stable: bool = True) -> Array",
    },
    "statistical functions": {
        "cumulative_sum": "def cumulative_sum(x: Array, /, *, axis: Optional[int] = None) -> Array",
        "max": "def max(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None, keepdims: bool = False) -> Array",
        "mean": "def mean(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None, keepdims: bool = False) -> Array",
        "min": "def min(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None, keepdims: bool = False) -> Array",
        "prod": "def prod(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None, keepdims: bool = False) -> Array",
        "std": "def std(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None, correction: int = 0, keepdims: bool = False) -> Array",
        "sum": "def sum(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None, keepdims: bool = False) -> Array",
        "var": "def var(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None, correction: int = 0, keepdims: bool = False) -> Array",
    },
    "utility functions": {
        "all": "def all(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None, keepdims: bool = False) -> Array",
        "any": "def any(x: Array, /, *, axis: Optional[Union[int, Tuple[int, ...]]] = None, keepdims: bool = False) -> Array",
    },
    "random": {},
    "linalg": {},
    "fft": {},
}

