"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabRunnerAutoscaling = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const gcp = require("@cdktf/provider-google");
const cdktf = require("cdktf");
const constructs_1 = require("constructs");
class GitlabRunnerAutoscaling extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const defaultProps = {
            desiredCapacity: 1,
            machineType: 'e2-medium',
            tags: ['gitlab', 'cdktf', 'runner'],
            gitlabUrl: 'https://gitlab.com/',
            gitlabRunnerImage: 'public.ecr.aws/gitlab/gitlab-runner:alpine',
            preemptible: true,
            automaticRestart: false,
            concurrent: 1,
            downloadGitlabRunnerBinaryUrl: 'https://gitlab-runner-downloads.s3.amazonaws.com/latest/binaries/gitlab-runner-linux-amd64',
        };
        const runnerProps = { ...defaultProps, ...props };
        const network = (_b = runnerProps === null || runnerProps === void 0 ? void 0 : runnerProps.computeNetwork) !== null && _b !== void 0 ? _b : new gcp.ComputeNetwork(this, 'Network', {
            name: 'cdktf-gitlabrunner-network',
        });
        const serviceAccount = new gcp.ServiceAccount(this, 'ServiceAccount', {
            accountId: 'gitlab-runner-sa',
            displayName: 'Gitlab Runner Servuce Account',
        });
        new gcp.ComputeFirewall(this, 'GitlabRunnerFirewallRule', {
            priority: 900,
            name: 'allow-ingress-from-iap',
            sourceRanges: ['35.235.240.0/20'],
            network: network.id,
            allow: [{
                    protocol: 'tcp',
                    ports: ['22'],
                }],
            targetTags: ['runner-iap'],
            dependsOn: [network],
        });
        new gcp.ProjectIamBinding(this, 'ComputeIamBinding', {
            provider: runnerProps.provider,
            role: 'roles/compute.admin',
            members: [`serviceAccount:${serviceAccount.email}`],
        });
        const networkTags = ['runner-iap'];
        if (runnerProps.networkTags) {
            networkTags.push(...runnerProps.networkTags);
        }
        const compute_template = new gcp.ComputeInstanceTemplate(this, 'cdktf-gitlabrunner-instance-template', {
            machineType: runnerProps.machineType,
            disk: [
                {
                    autoDelete: true,
                    boot: true,
                    diskSizeGb: (_c = props.defaultDiskSizeGb) !== null && _c !== void 0 ? _c : 60,
                    sourceImage: 'cos-cloud/cos-stable',
                },
            ],
            serviceAccount: runnerProps.serviceAccount ? runnerProps.serviceAccount : { email: serviceAccount.email, scopes: ['cloud-platform'] },
            canIpForward: true,
            description: 'cdktf-gitlabrunner-instance-template',
            name: 'cdktf-gitlabrunner-instance-template',
            metadata: {
                'user-data': this.createMetadataStartupScript(runnerProps).join('\n'),
                'shutdown-script': this.createShutdwonScript().join('\n'),
            },
            provider: runnerProps.provider,
            networkInterface: [
                {
                    network: network.id,
                    accessConfig: [{}],
                },
            ],
            tags: networkTags,
            lifecycle: {
                createBeforeDestroy: true,
            },
            scheduling: {
                preemptible: runnerProps.preemptible,
                automaticRestart: runnerProps.automaticRestart,
            },
        });
        new gcp.ComputeInstanceGroupManager(this, 'instance-group', {
            provider: runnerProps.provider,
            name: 'cdktf-gitlabrunner-instance-group',
            baseInstanceName: 'scaling-gitlab-runner',
            version: [{
                    instanceTemplate: compute_template.id,
                }],
            lifecycle: {
                createBeforeDestroy: true,
            },
            targetSize: runnerProps.desiredCapacity,
            dependsOn: [compute_template, serviceAccount],
        });
        new cdktf.TerraformOutput(this, 'ComputeNetworkName', {
            value: network.name,
        });
    }
    dockerVolumesList(dockerVolume) {
        let tempString = '--docker-volumes "/var/run/docker.sock:/var/run/docker.sock"';
        if (dockerVolume) {
            let tempList = [];
            dockerVolume.forEach(e => {
                tempList.push(`"${e.hostPath}:${e.containerPath}"`);
            });
            tempList.forEach(e => {
                tempString = `${tempString} --docker-volumes ${e}`;
            });
        }
        return tempString;
    }
    /**
     * @param props
     * @returns Array.
     */
    createMetadataStartupScript(props) {
        var _b;
        return [
            `Content-Type: multipart/mixed; boundary="MIMEBOUNDARY"
MIME-Version: 1.0

--MIMEBOUNDARY
Content-Disposition: attachment; filename="init.cfg"
Content-Transfer-Encoding: 7bit
Content-Type: text/cloud-config
Mime-Version: 1.0

`,
            `# cloud-config
users:
  - name: gitlab-runner
    shell: /bin/bash
    uid: 2000
    groups:
      - docker

write_files:
  - path: /etc/gitlab-runner/config.toml
    owner: root:root
    permissions: '0644'
    content: |
      # Prometheus metrics at /metrics, also used for health checks.
      listen_address = ":9252"
      concurrent = ${props.concurrent}
  - path: /var/lib/cloud/bin/firewall
    permissions: 0755
    owner: root
    content: |
      #! /bin/bash
      iptables -w -A INPUT -p tcp --dport 9252 -j ACCEPT
  - path: /etc/systemd/system/gitlab-runner-register.service
    permissions: 0644
    owner: root
    content: |
      [Unit]
      Description=GitLab Runner Registration/Unregistration
      ConditionFileIsExecutable=/var/lib/google/bin/gitlab-runner
      After=syslog.target network-online.target
      [Service]
      Type=oneshot
      RemainAfterExit=yes
      ExecStart=/var/lib/google/bin/gitlab-runner register --non-interactive --url "${props.gitlabUrl}" --executor "docker" --registration-token ${props.gitlabToken} --docker-image alpine:latest --tag-list "${(_b = props.tags) === null || _b === void 0 ? void 0 : _b.join(',')}" --locked="false" --access-level="not_protected" ${this.dockerVolumesList(props === null || props === void 0 ? void 0 : props.dockerVolumes)} --description "A Runner on GCP GCE (${props.machineType})" --docker-privileged
      ExecStop=/var/lib/google/bin/gitlab-runner "unregister" "--config" "/etc/gitlab-runner/config.toml" "--all-runners"
      [Install]
      WantedBy=multi-user.target
  - path: /etc/systemd/system/gitlab-runner.service
    permissions: 0644
    owner: root
    content: |
      [Unit]
      Description=GitLab Runner
      ConditionFileIsExecutable=/var/lib/google/bin/gitlab-runner
      After=gitlab-runner-register.service syslog.target network-online.target
      Requires=gitlab-runner-register.service
      [Service]
      StartLimitInterval=5
      StartLimitBurst=10
      ExecStart=/var/lib/google/bin/gitlab-runner "run" "--working-directory" "/home/gitlab-runner" "--config" "/etc/gitlab-runner/config.toml" "--service" "gitlab-runner" "--syslog" "--user" "gitlab-runner"
      Restart=always
      RestartSec=120
      [Install]
      WantedBy=multi-user.target
  - path: /etc/systemd/system/firewall.service
    permissions: 0644
    owner: root
    content: |
      [Unit]
      Description=Host firewall configuration
      ConditionFileIsExecutable=/var/lib/cloud/bin/firewall
      After=network-online.target
      [Service]
      ExecStart=/var/lib/cloud/bin/firewall
      Type=oneshot
      [Install]
      WantedBy=multi-user.target

runcmd:
  - mkdir /var/lib/google/tmp
  - mkdir /var/lib/google/bin
  - curl -L --output /var/lib/google/tmp/gitlab-runner ${props.downloadGitlabRunnerBinaryUrl}
  - install -o 0 -g 0 -m 0755 /var/lib/google/tmp/gitlab-runner /var/lib/google/bin/gitlab-runner
  - systemctl daemon-reload
  - systemctl start firewall.service
  - systemctl start gitlab-runner-register.service
  - systemctl start gitlab-runner.service
  - chmod +x /var/run/docker.sock

--MIMEBOUNDARY--
`,
        ];
    }
    createShutdwonScript() {
        return ['#!/bin/bash', '/var/lib/google/bin/gitlab-runner unregister --all-runners'];
    }
}
exports.GitlabRunnerAutoscaling = GitlabRunnerAutoscaling;
_a = JSII_RTTI_SYMBOL_1;
GitlabRunnerAutoscaling[_a] = { fqn: "cdktf-gitlab-runner.GitlabRunnerAutoscaling", version: "0.0.208" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0bGFiLXJ1bm5lci1hdXRvc2NhbGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9naXRsYWItcnVubmVyLWF1dG9zY2FsaW5nLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsOENBQThDO0FBQzlDLCtCQUErQjtBQUMvQiwyQ0FBdUM7QUE0SXZDLE1BQWEsdUJBQXdCLFNBQVEsc0JBQVM7SUFDcEQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFtQzs7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixNQUFNLFlBQVksR0FBRztZQUNuQixlQUFlLEVBQUUsQ0FBQztZQUNsQixXQUFXLEVBQUUsV0FBVztZQUN4QixJQUFJLEVBQUUsQ0FBQyxRQUFRLEVBQUUsT0FBTyxFQUFFLFFBQVEsQ0FBQztZQUNuQyxTQUFTLEVBQUUscUJBQXFCO1lBQ2hDLGlCQUFpQixFQUFFLDRDQUE0QztZQUMvRCxXQUFXLEVBQUUsSUFBSTtZQUNqQixnQkFBZ0IsRUFBRSxLQUFLO1lBQ3ZCLFVBQVUsRUFBRSxDQUFDO1lBQ2IsNkJBQTZCLEVBQUUsNEZBQTRGO1NBQzVILENBQUM7UUFDRixNQUFNLFdBQVcsR0FBRyxFQUFFLEdBQUcsWUFBWSxFQUFFLEdBQUcsS0FBSyxFQUFFLENBQUM7UUFDbEQsTUFBTSxPQUFPLFNBQUcsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLGNBQWMsbUNBQUksSUFBSSxHQUFHLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7WUFDckYsSUFBSSxFQUFFLDRCQUE0QjtTQUNuQyxDQUFDLENBQUM7UUFDSCxNQUFNLGNBQWMsR0FBRyxJQUFJLEdBQUcsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFO1lBQ3BFLFNBQVMsRUFBRSxrQkFBa0I7WUFDN0IsV0FBVyxFQUFFLCtCQUErQjtTQUM3QyxDQUFDLENBQUM7UUFDSCxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLDBCQUEwQixFQUFFO1lBQ3hELFFBQVEsRUFBRSxHQUFHO1lBQ2IsSUFBSSxFQUFFLHdCQUF3QjtZQUM5QixZQUFZLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQztZQUNqQyxPQUFPLEVBQUUsT0FBTyxDQUFDLEVBQUU7WUFDbkIsS0FBSyxFQUFFLENBQUM7b0JBQ04sUUFBUSxFQUFFLEtBQUs7b0JBQ2YsS0FBSyxFQUFFLENBQUMsSUFBSSxDQUFDO2lCQUNkLENBQUM7WUFDRixVQUFVLEVBQUUsQ0FBQyxZQUFZLENBQUM7WUFDMUIsU0FBUyxFQUFFLENBQUMsT0FBTyxDQUFDO1NBQ3JCLENBQUMsQ0FBQztRQUVILElBQUksR0FBRyxDQUFDLGlCQUFpQixDQUFDLElBQUksRUFBRSxtQkFBbUIsRUFBRTtZQUNuRCxRQUFRLEVBQUUsV0FBVyxDQUFDLFFBQVE7WUFDOUIsSUFBSSxFQUFFLHFCQUFxQjtZQUMzQixPQUFPLEVBQUUsQ0FBQyxrQkFBa0IsY0FBYyxDQUFDLEtBQUssRUFBRSxDQUFDO1NBQ3BELENBQUMsQ0FBQztRQUVILE1BQU0sV0FBVyxHQUFHLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDbkMsSUFBSSxXQUFXLENBQUMsV0FBVyxFQUFFO1lBQzNCLFdBQVcsQ0FBQyxJQUFJLENBQUMsR0FBRyxXQUFXLENBQUMsV0FBVyxDQUFDLENBQUM7U0FDOUM7UUFDRCxNQUFNLGdCQUFnQixHQUFHLElBQUksR0FBRyxDQUFDLHVCQUF1QixDQUFDLElBQUksRUFBRSxzQ0FBc0MsRUFBRTtZQUNyRyxXQUFXLEVBQUUsV0FBVyxDQUFDLFdBQVc7WUFDcEMsSUFBSSxFQUFFO2dCQUNKO29CQUNFLFVBQVUsRUFBRSxJQUFJO29CQUNoQixJQUFJLEVBQUUsSUFBSTtvQkFDVixVQUFVLFFBQUUsS0FBSyxDQUFDLGlCQUFpQixtQ0FBSSxFQUFFO29CQUN6QyxXQUFXLEVBQUUsc0JBQXNCO2lCQUNwQzthQUNGO1lBQ0QsY0FBYyxFQUFFLFdBQVcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFdBQVcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLEVBQUUsS0FBSyxFQUFFLGNBQWMsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLENBQUMsZ0JBQWdCLENBQUMsRUFBRTtZQUNySSxZQUFZLEVBQUUsSUFBSTtZQUNsQixXQUFXLEVBQUUsc0NBQXNDO1lBQ25ELElBQUksRUFBRSxzQ0FBc0M7WUFDNUMsUUFBUSxFQUFFO2dCQUNSLFdBQVcsRUFBRSxJQUFJLENBQUMsMkJBQTJCLENBQUMsV0FBVyxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztnQkFDckUsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQzthQUMxRDtZQUNELFFBQVEsRUFBRSxXQUFXLENBQUMsUUFBUTtZQUM5QixnQkFBZ0IsRUFBRTtnQkFDaEI7b0JBQ0UsT0FBTyxFQUFFLE9BQU8sQ0FBQyxFQUFFO29CQUNuQixZQUFZLEVBQUUsQ0FBQyxFQUFFLENBQUM7aUJBQ25CO2FBQ0Y7WUFDRCxJQUFJLEVBQUUsV0FBVztZQUNqQixTQUFTLEVBQUU7Z0JBQ1QsbUJBQW1CLEVBQUUsSUFBSTthQUMxQjtZQUNELFVBQVUsRUFDUjtnQkFDRSxXQUFXLEVBQUUsV0FBVyxDQUFDLFdBQVc7Z0JBQ3BDLGdCQUFnQixFQUFFLFdBQVcsQ0FBQyxnQkFBZ0I7YUFDL0M7U0FDSixDQUFDLENBQUM7UUFFSCxJQUFJLEdBQUcsQ0FBQywyQkFBMkIsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7WUFDMUQsUUFBUSxFQUFFLFdBQVcsQ0FBQyxRQUFRO1lBQzlCLElBQUksRUFBRSxtQ0FBbUM7WUFDekMsZ0JBQWdCLEVBQUUsdUJBQXVCO1lBQ3pDLE9BQU8sRUFBRSxDQUFDO29CQUNSLGdCQUFnQixFQUFFLGdCQUFnQixDQUFDLEVBQUU7aUJBQ3RDLENBQUM7WUFDRixTQUFTLEVBQUU7Z0JBQ1QsbUJBQW1CLEVBQUUsSUFBSTthQUMxQjtZQUNELFVBQVUsRUFBRSxXQUFXLENBQUMsZUFBZTtZQUN2QyxTQUFTLEVBQUUsQ0FBQyxnQkFBZ0IsRUFBRSxjQUFjLENBQUM7U0FDOUMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxLQUFLLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSxvQkFBb0IsRUFBRTtZQUNwRCxLQUFLLEVBQUUsT0FBTyxDQUFDLElBQUk7U0FDcEIsQ0FBQyxDQUFDO0lBR0wsQ0FBQztJQUNPLGlCQUFpQixDQUFDLFlBQXlDO1FBQ2pFLElBQUksVUFBVSxHQUFXLDhEQUE4RCxDQUFDO1FBQ3hGLElBQUksWUFBWSxFQUFFO1lBQ2hCLElBQUksUUFBUSxHQUFhLEVBQUUsQ0FBQztZQUM1QixZQUFZLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFO2dCQUN2QixRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLFFBQVEsSUFBSSxDQUFDLENBQUMsYUFBYSxHQUFHLENBQUMsQ0FBQztZQUN0RCxDQUFDLENBQUMsQ0FBQztZQUNILFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUU7Z0JBQ25CLFVBQVUsR0FBRyxHQUFHLFVBQVUscUJBQXFCLENBQUMsRUFBRSxDQUFDO1lBQ3JELENBQUMsQ0FBQyxDQUFDO1NBQ0o7UUFDRCxPQUFPLFVBQVUsQ0FBQztJQUNwQixDQUFDO0lBQ0Q7OztPQUdHO0lBQ0ksMkJBQTJCLENBQUMsS0FBbUM7O1FBQ3BFLE9BQU87WUFDTDs7Ozs7Ozs7O0NBU0w7WUFBRTs7Ozs7Ozs7Ozs7Ozs7O3FCQWVrQixLQUFLLENBQUMsVUFBVTs7Ozs7Ozs7Ozs7Ozs7Ozs7O3NGQWtCaUQsS0FBSyxDQUFDLFNBQVMsOENBQThDLEtBQUssQ0FBQyxXQUFXLDZDQUE2QyxNQUFBLEtBQUssQ0FBQyxJQUFJLDBDQUFFLElBQUksQ0FBQyxHQUFHLENBQUMscURBQXFELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsYUFBYSxDQUFDLHdDQUF3QyxLQUFLLENBQUMsV0FBVzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7eURBc0N2VSxLQUFLLENBQUMsNkJBQTZCOzs7Ozs7Ozs7Q0FTM0Y7U0FDSSxDQUFDO0lBQ0osQ0FBQztJQUNPLG9CQUFvQjtRQUMxQixPQUFPLENBQUMsYUFBYSxFQUFFLDREQUE0RCxDQUFDLENBQUM7SUFDdkYsQ0FBQzs7QUF0TkgsMERBdU5DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZ2NwIGZyb20gJ0BjZGt0Zi9wcm92aWRlci1nb29nbGUnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBEb2NrZXJWb2x1bWVzIH0gZnJvbSAnLi9naXRsYWItcnVubmVyLWludGVyZmFjZXMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEdpdGxhYlJ1bm5lckF1dG9zY2FsaW5nUHJvcHMge1xuICAvKipcbiAgICogR29vZ2xlIENsb3VkIFByb3ZpZGVyLlxuICAqL1xuICByZWFkb25seSBwcm92aWRlcjogZ2NwLkdvb2dsZVByb3ZpZGVyO1xuICAvKipcbiAgICogR2l0bGFiIHRva2VuLlxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBuZXcgR2l0bGFiUnVubmVyQXV0b3NjYWxpbmcoc3RhY2ssICdydW5uZXInLCB7IGdpdGxhYlRva2VuOiAnR0lUTEFCX1RPS0VOJyB9KTtcbiAgICovXG4gIHJlYWRvbmx5IGdpdGxhYlRva2VuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFJ1bm5lciBkZWZhdWx0IEVDMiBpbnN0YW5jZSB0eXBlLlxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBuZXcgR2l0bGFiUnVubmVyQXV0b3NjYWxpbmcoc3RhY2ssICdydW5uZXInLCB7IGdpdGxhYlRva2VuOiAnR0lUTEFCX1RPS0VOJywgaW5zdGFuY2VUeXBlOiAndDMuc21hbGwnIH0pO1xuICAgKlxuICAgKiBAZGVmYXVsdCAtXG4gICAqXG4gICAqL1xuICByZWFkb25seSBtYWNoaW5lVHlwZT86IHN0cmluZztcblxuICAvKipcbiAgICogVlBDIGZvciB0aGUgR2l0bGFiIFJ1bm5lciAuXG4gICAqXG4gICAqIEBleGFtcGxlXG4gICAqIGNvbnN0IGNvbXB1dGVOZXR3b3JrID0gbmV3IGdjcC5Db21wdXRlTmV0d29yayh0aGlzLCAnTmV0d29yaycsIHtcbiAgICogICBuYW1lOiAnY2RrdGYtZ2l0bGFicnVubmVyLW5ldHdvcmsnLFxuICAgKiB9KTtcbiAgICpcbiAgICogbmV3IEdpdGxhYlJ1bm5lckF1dG9zY2FsaW5nKHN0YWNrLCAncnVubmVyJywgeyBnaXRsYWJUb2tlbjogJ0dJVExBQl9UT0tFTicsIGNvbXB1dGVOZXR3b3JrOiBjb21wdXRlTmV0d29yayB9KTtcbiAgICpcbiAgICogQGRlZmF1bHQgLSBBIG5ldyBWUEMgd2lsbCBiZSBjcmVhdGVkLlxuICAgKlxuICAgKi9cbiAgcmVhZG9ubHkgY29tcHV0ZU5ldHdvcms/OiBnY3AuRGF0YUdvb2dsZUNvbXB1dGVOZXR3b3JrO1xuXG4gIC8qKlxuICAgKiBEZXNpcmVkIGNhcGFjaXR5IGxpbWl0IGZvciBhdXRvc2NhbGluZyBncm91cC5cbiAgICpcbiAgICogQGV4YW1wbGVcbiAgICogbmV3IEdpdGxhYlJ1bm5lckF1dG9zY2FsaW5nKHN0YWNrLCAncnVubmVyJywgeyBnaXRsYWJUb2tlbjogJ0dJVExBQl9UT0tFTicsIGRlc2lyZWRDYXBhY2l0eTogMiB9KTtcbiAgICpcbiAgICogQGRlZmF1bHQgLSBtaW5DYXBhY2l0eSwgYW5kIGxlYXZlIHVuY2hhbmdlZCBkdXJpbmcgZGVwbG95bWVudFxuICAgKlxuICAgKi9cbiAgcmVhZG9ubHkgZGVzaXJlZENhcGFjaXR5PzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiB0YWdzIGZvciB0aGUgcnVubmVyXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gWydydW5uZXInLCAnZ2l0bGFiJywgJ2F3c2NkayddXG4gICAqL1xuICByZWFkb25seSB0YWdzPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIEdpdGxhYiBSdW5uZXIgcmVnaXN0ZXIgdXJsIC5cbiAgICpcbiAgICogQGV4YW1wbGVcbiAgICogY29uc3QgcnVubmVyID0gbmV3IEdpdGxhYlJ1bm5lckF1dG9zY2FsaW5nKHN0YWNrLCAncnVubmVyJywgeyBnaXRsYWJUb2tlbjogJ0dJVExBQl9UT0tFTicsZ2l0bGFiVXJsOiAnaHR0cHM6Ly9naXRsYWIuY29tLyd9KTtcbiAgICpcbiAgICogQGRlZmF1bHQgLSBodHRwczovL2dpdGxhYi5jb20vICwgVGhlIHRyYWlsaW5nIHNsYXNoIGlzIG1hbmRhdG9yeS5cbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IGdpdGxhYlVybD86IHN0cmluZztcblxuICAvKipcbiAgICogYWRkIGFub3RoZXIgR2l0bGFiIENvbnRhaW5lciBSdW5uZXIgRG9ja2VyIFZvbHVtZXMgUGF0aCBhdCBqb2IgcnVubmVyIHJ1bnRpbWUuXG4gICAqXG4gICAqIG1vcmUgZGV0YWlsIHNlZSBodHRwczovL2RvY3MuZ2l0bGFiLmNvbS9ydW5uZXIvY29uZmlndXJhdGlvbi9hZHZhbmNlZC1jb25maWd1cmF0aW9uLmh0bWwjdGhlLXJ1bm5lcnNkb2NrZXItc2VjdGlvblxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGFscmVhZHkgbW91bnQgXCIvdmFyL3J1bi9kb2NrZXIuc29jazovdmFyL3J1bi9kb2NrZXIuc29ja1wiXG4gICAqXG4gICAqIEBleGFtcGxlXG4gICAqIGRvY2tlclZvbHVtZXM6IFtcbiAgICogICB7XG4gICAqICAgICBob3N0UGF0aDogJy90bXAvY2FjaGUnLFxuICAgKiAgICAgY29udGFpbmVyUGF0aDogJy90bXAvY2FjaGUnLFxuICAgKiAgIH0sXG4gICAqIF0sXG4gICAqL1xuICByZWFkb25seSBkb2NrZXJWb2x1bWVzPzogRG9ja2VyVm9sdW1lc1tdO1xuXG5cbiAgLyoqXG4gICAqIEdpdGxhYiBSdW5uZXIgaW5zdGFuY2UgRGlzayBzaXplLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIDYwIEdCLlxuICAqL1xuICByZWFkb25seSBkZWZhdWx0RGlza1NpemVHYj8gOiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBTZXJ2aWNlIEFjY291bnQgdG8gYmUgdXNlZCBieSB0aGUgR2l0bGFiIFJ1bm5lci5cbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VBY2NvdW50PzogZ2NwLkNvbXB1dGVJbnN0YW5jZVRlbXBsYXRlU2VydmljZUFjY291bnQ7XG5cbiAgLyoqXG4gICAqIEZpcmV3YWxsIHJ1bGVzIGZvciB0aGUgR2l0bGFiIFJ1bm5lci5cbiAgICovXG4gIHJlYWRvbmx5IG5ldHdvcmtUYWdzPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIElmIHRydWUsIGNyZWF0ZSBwcmVlbXB0aWJsZSBWTSBpbnN0YW5jZXMgaW50ZW5kZWQgdG8gcmVkdWNlIGNvc3QuXG4gICAqIE5vdGUsIHRoZSBNSUcgd2lsbCByZWNyZWF0ZSBwcmUtZW1wdGVkIGluc3RuYWNlcy5cbiAgICogU2VlIGh0dHBzOi8vY2xvdWQuZ29vZ2xlLmNvbS9jb21wdXRlL2RvY3MvaW5zdGFuY2VzL3ByZWVtcHRpYmxlXG4gICAqXG4gICAqIEBkZWFmdWx0IC0gdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgcHJlZW1wdGlibGU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKlxuICAgKiBJZiB0cnVlLCBhdXRvbWF0aWNhbGx5IHJlc3RhcnQgaW5zdGFuY2VzIG9uIG1haW50ZW5hbmNlIGV2ZW50cy5cbiAgICogU2VlIGh0dHBzOi8vY2xvdWQuZ29vZ2xlLmNvbS9jb21wdXRlL2RvY3MvaW5zdGFuY2VzL2xpdmUtbWlncmF0aW9uI2F1dG9yZXN0YXJ0XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGF1dG9tYXRpY1Jlc3RhcnQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBnaXRsYWIgcnVubmVyIHJ1biB0YXNrIGNvbmN1cnJlbnQgYXQgdGhlIHNhbWUgdGltZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSAxXG4gICAqL1xuICByZWFkb25seSBjb25jdXJyZW50PzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgc291cmNlIFVSTCB1c2VkIHRvIGluc3RhbGwgdGhlIGdpdGxhYi1ydW5uZXIgb250byB0aGUgVk0gaG9zdCBvcy5cbiAgICogUGFzc2VkIHRvIGN1cmwgdmlhIGNsb3VkLWNvbmZpZyBydW5jbWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gXCJodHRwczovL2dpdGxhYi1ydW5uZXItZG93bmxvYWRzLnMzLmFtYXpvbmF3cy5jb20vbGF0ZXN0L2JpbmFyaWVzL2dpdGxhYi1ydW5uZXItbGludXgtYW1kNjRcIlxuICAgKi9cbiAgcmVhZG9ubHkgZG93bmxvYWRHaXRsYWJSdW5uZXJCaW5hcnlVcmw/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBHaXRsYWJSdW5uZXJBdXRvc2NhbGluZyBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkIDpzdHJpbmcsIHByb3BzOiBHaXRsYWJSdW5uZXJBdXRvc2NhbGluZ1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBjb25zdCBkZWZhdWx0UHJvcHMgPSB7XG4gICAgICBkZXNpcmVkQ2FwYWNpdHk6IDEsXG4gICAgICBtYWNoaW5lVHlwZTogJ2UyLW1lZGl1bScsXG4gICAgICB0YWdzOiBbJ2dpdGxhYicsICdjZGt0ZicsICdydW5uZXInXSxcbiAgICAgIGdpdGxhYlVybDogJ2h0dHBzOi8vZ2l0bGFiLmNvbS8nLFxuICAgICAgZ2l0bGFiUnVubmVySW1hZ2U6ICdwdWJsaWMuZWNyLmF3cy9naXRsYWIvZ2l0bGFiLXJ1bm5lcjphbHBpbmUnLFxuICAgICAgcHJlZW1wdGlibGU6IHRydWUsXG4gICAgICBhdXRvbWF0aWNSZXN0YXJ0OiBmYWxzZSxcbiAgICAgIGNvbmN1cnJlbnQ6IDEsXG4gICAgICBkb3dubG9hZEdpdGxhYlJ1bm5lckJpbmFyeVVybDogJ2h0dHBzOi8vZ2l0bGFiLXJ1bm5lci1kb3dubG9hZHMuczMuYW1hem9uYXdzLmNvbS9sYXRlc3QvYmluYXJpZXMvZ2l0bGFiLXJ1bm5lci1saW51eC1hbWQ2NCcsXG4gICAgfTtcbiAgICBjb25zdCBydW5uZXJQcm9wcyA9IHsgLi4uZGVmYXVsdFByb3BzLCAuLi5wcm9wcyB9O1xuICAgIGNvbnN0IG5ldHdvcmsgPSBydW5uZXJQcm9wcz8uY29tcHV0ZU5ldHdvcmsgPz8gbmV3IGdjcC5Db21wdXRlTmV0d29yayh0aGlzLCAnTmV0d29yaycsIHtcbiAgICAgIG5hbWU6ICdjZGt0Zi1naXRsYWJydW5uZXItbmV0d29yaycsXG4gICAgfSk7XG4gICAgY29uc3Qgc2VydmljZUFjY291bnQgPSBuZXcgZ2NwLlNlcnZpY2VBY2NvdW50KHRoaXMsICdTZXJ2aWNlQWNjb3VudCcsIHtcbiAgICAgIGFjY291bnRJZDogJ2dpdGxhYi1ydW5uZXItc2EnLFxuICAgICAgZGlzcGxheU5hbWU6ICdHaXRsYWIgUnVubmVyIFNlcnZ1Y2UgQWNjb3VudCcsXG4gICAgfSk7XG4gICAgbmV3IGdjcC5Db21wdXRlRmlyZXdhbGwodGhpcywgJ0dpdGxhYlJ1bm5lckZpcmV3YWxsUnVsZScsIHtcbiAgICAgIHByaW9yaXR5OiA5MDAsXG4gICAgICBuYW1lOiAnYWxsb3ctaW5ncmVzcy1mcm9tLWlhcCcsXG4gICAgICBzb3VyY2VSYW5nZXM6IFsnMzUuMjM1LjI0MC4wLzIwJ10sXG4gICAgICBuZXR3b3JrOiBuZXR3b3JrLmlkLFxuICAgICAgYWxsb3c6IFt7XG4gICAgICAgIHByb3RvY29sOiAndGNwJyxcbiAgICAgICAgcG9ydHM6IFsnMjInXSxcbiAgICAgIH1dLFxuICAgICAgdGFyZ2V0VGFnczogWydydW5uZXItaWFwJ10sXG4gICAgICBkZXBlbmRzT246IFtuZXR3b3JrXSxcbiAgICB9KTtcblxuICAgIG5ldyBnY3AuUHJvamVjdElhbUJpbmRpbmcodGhpcywgJ0NvbXB1dGVJYW1CaW5kaW5nJywge1xuICAgICAgcHJvdmlkZXI6IHJ1bm5lclByb3BzLnByb3ZpZGVyLFxuICAgICAgcm9sZTogJ3JvbGVzL2NvbXB1dGUuYWRtaW4nLFxuICAgICAgbWVtYmVyczogW2BzZXJ2aWNlQWNjb3VudDoke3NlcnZpY2VBY2NvdW50LmVtYWlsfWBdLFxuICAgIH0pO1xuXG4gICAgY29uc3QgbmV0d29ya1RhZ3MgPSBbJ3J1bm5lci1pYXAnXTtcbiAgICBpZiAocnVubmVyUHJvcHMubmV0d29ya1RhZ3MpIHtcbiAgICAgIG5ldHdvcmtUYWdzLnB1c2goLi4ucnVubmVyUHJvcHMubmV0d29ya1RhZ3MpO1xuICAgIH1cbiAgICBjb25zdCBjb21wdXRlX3RlbXBsYXRlID0gbmV3IGdjcC5Db21wdXRlSW5zdGFuY2VUZW1wbGF0ZSh0aGlzLCAnY2RrdGYtZ2l0bGFicnVubmVyLWluc3RhbmNlLXRlbXBsYXRlJywge1xuICAgICAgbWFjaGluZVR5cGU6IHJ1bm5lclByb3BzLm1hY2hpbmVUeXBlLFxuICAgICAgZGlzazogW1xuICAgICAgICB7XG4gICAgICAgICAgYXV0b0RlbGV0ZTogdHJ1ZSxcbiAgICAgICAgICBib290OiB0cnVlLFxuICAgICAgICAgIGRpc2tTaXplR2I6IHByb3BzLmRlZmF1bHREaXNrU2l6ZUdiID8/IDYwLFxuICAgICAgICAgIHNvdXJjZUltYWdlOiAnY29zLWNsb3VkL2Nvcy1zdGFibGUnLFxuICAgICAgICB9LFxuICAgICAgXSxcbiAgICAgIHNlcnZpY2VBY2NvdW50OiBydW5uZXJQcm9wcy5zZXJ2aWNlQWNjb3VudCA/IHJ1bm5lclByb3BzLnNlcnZpY2VBY2NvdW50IDogeyBlbWFpbDogc2VydmljZUFjY291bnQuZW1haWwsIHNjb3BlczogWydjbG91ZC1wbGF0Zm9ybSddIH0sXG4gICAgICBjYW5JcEZvcndhcmQ6IHRydWUsXG4gICAgICBkZXNjcmlwdGlvbjogJ2Nka3RmLWdpdGxhYnJ1bm5lci1pbnN0YW5jZS10ZW1wbGF0ZScsXG4gICAgICBuYW1lOiAnY2RrdGYtZ2l0bGFicnVubmVyLWluc3RhbmNlLXRlbXBsYXRlJyxcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgICd1c2VyLWRhdGEnOiB0aGlzLmNyZWF0ZU1ldGFkYXRhU3RhcnR1cFNjcmlwdChydW5uZXJQcm9wcykuam9pbignXFxuJyksXG4gICAgICAgICdzaHV0ZG93bi1zY3JpcHQnOiB0aGlzLmNyZWF0ZVNodXRkd29uU2NyaXB0KCkuam9pbignXFxuJyksXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IHJ1bm5lclByb3BzLnByb3ZpZGVyLFxuICAgICAgbmV0d29ya0ludGVyZmFjZTogW1xuICAgICAgICB7XG4gICAgICAgICAgbmV0d29yazogbmV0d29yay5pZCxcbiAgICAgICAgICBhY2Nlc3NDb25maWc6IFt7fV0sXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgICAgdGFnczogbmV0d29ya1RhZ3MsXG4gICAgICBsaWZlY3ljbGU6IHtcbiAgICAgICAgY3JlYXRlQmVmb3JlRGVzdHJveTogdHJ1ZSxcbiAgICAgIH0sXG4gICAgICBzY2hlZHVsaW5nOlxuICAgICAgICB7XG4gICAgICAgICAgcHJlZW1wdGlibGU6IHJ1bm5lclByb3BzLnByZWVtcHRpYmxlLFxuICAgICAgICAgIGF1dG9tYXRpY1Jlc3RhcnQ6IHJ1bm5lclByb3BzLmF1dG9tYXRpY1Jlc3RhcnQsXG4gICAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBuZXcgZ2NwLkNvbXB1dGVJbnN0YW5jZUdyb3VwTWFuYWdlcih0aGlzLCAnaW5zdGFuY2UtZ3JvdXAnLCB7XG4gICAgICBwcm92aWRlcjogcnVubmVyUHJvcHMucHJvdmlkZXIsXG4gICAgICBuYW1lOiAnY2RrdGYtZ2l0bGFicnVubmVyLWluc3RhbmNlLWdyb3VwJyxcbiAgICAgIGJhc2VJbnN0YW5jZU5hbWU6ICdzY2FsaW5nLWdpdGxhYi1ydW5uZXInLFxuICAgICAgdmVyc2lvbjogW3tcbiAgICAgICAgaW5zdGFuY2VUZW1wbGF0ZTogY29tcHV0ZV90ZW1wbGF0ZS5pZCxcbiAgICAgIH1dLFxuICAgICAgbGlmZWN5Y2xlOiB7XG4gICAgICAgIGNyZWF0ZUJlZm9yZURlc3Ryb3k6IHRydWUsXG4gICAgICB9LFxuICAgICAgdGFyZ2V0U2l6ZTogcnVubmVyUHJvcHMuZGVzaXJlZENhcGFjaXR5LFxuICAgICAgZGVwZW5kc09uOiBbY29tcHV0ZV90ZW1wbGF0ZSwgc2VydmljZUFjY291bnRdLFxuICAgIH0pO1xuXG4gICAgbmV3IGNka3RmLlRlcnJhZm9ybU91dHB1dCh0aGlzLCAnQ29tcHV0ZU5ldHdvcmtOYW1lJywge1xuICAgICAgdmFsdWU6IG5ldHdvcmsubmFtZSxcbiAgICB9KTtcblxuXG4gIH1cbiAgcHJpdmF0ZSBkb2NrZXJWb2x1bWVzTGlzdChkb2NrZXJWb2x1bWU6IERvY2tlclZvbHVtZXNbXSB8IHVuZGVmaW5lZCk6IHN0cmluZyB7XG4gICAgbGV0IHRlbXBTdHJpbmc6IHN0cmluZyA9ICctLWRvY2tlci12b2x1bWVzIFwiL3Zhci9ydW4vZG9ja2VyLnNvY2s6L3Zhci9ydW4vZG9ja2VyLnNvY2tcIic7XG4gICAgaWYgKGRvY2tlclZvbHVtZSkge1xuICAgICAgbGV0IHRlbXBMaXN0OiBzdHJpbmdbXSA9IFtdO1xuICAgICAgZG9ja2VyVm9sdW1lLmZvckVhY2goZSA9PiB7XG4gICAgICAgIHRlbXBMaXN0LnB1c2goYFwiJHtlLmhvc3RQYXRofToke2UuY29udGFpbmVyUGF0aH1cImApO1xuICAgICAgfSk7XG4gICAgICB0ZW1wTGlzdC5mb3JFYWNoKGUgPT4ge1xuICAgICAgICB0ZW1wU3RyaW5nID0gYCR7dGVtcFN0cmluZ30gLS1kb2NrZXItdm9sdW1lcyAke2V9YDtcbiAgICAgIH0pO1xuICAgIH1cbiAgICByZXR1cm4gdGVtcFN0cmluZztcbiAgfVxuICAvKipcbiAgICogQHBhcmFtIHByb3BzXG4gICAqIEByZXR1cm5zIEFycmF5LlxuICAgKi9cbiAgcHVibGljIGNyZWF0ZU1ldGFkYXRhU3RhcnR1cFNjcmlwdChwcm9wczogR2l0bGFiUnVubmVyQXV0b3NjYWxpbmdQcm9wcyk6IHN0cmluZ1tdIHtcbiAgICByZXR1cm4gW1xuICAgICAgYENvbnRlbnQtVHlwZTogbXVsdGlwYXJ0L21peGVkOyBib3VuZGFyeT1cIk1JTUVCT1VOREFSWVwiXG5NSU1FLVZlcnNpb246IDEuMFxuXG4tLU1JTUVCT1VOREFSWVxuQ29udGVudC1EaXNwb3NpdGlvbjogYXR0YWNobWVudDsgZmlsZW5hbWU9XCJpbml0LmNmZ1wiXG5Db250ZW50LVRyYW5zZmVyLUVuY29kaW5nOiA3Yml0XG5Db250ZW50LVR5cGU6IHRleHQvY2xvdWQtY29uZmlnXG5NaW1lLVZlcnNpb246IDEuMFxuXG5gLCBgIyBjbG91ZC1jb25maWdcbnVzZXJzOlxuICAtIG5hbWU6IGdpdGxhYi1ydW5uZXJcbiAgICBzaGVsbDogL2Jpbi9iYXNoXG4gICAgdWlkOiAyMDAwXG4gICAgZ3JvdXBzOlxuICAgICAgLSBkb2NrZXJcblxud3JpdGVfZmlsZXM6XG4gIC0gcGF0aDogL2V0Yy9naXRsYWItcnVubmVyL2NvbmZpZy50b21sXG4gICAgb3duZXI6IHJvb3Q6cm9vdFxuICAgIHBlcm1pc3Npb25zOiAnMDY0NCdcbiAgICBjb250ZW50OiB8XG4gICAgICAjIFByb21ldGhldXMgbWV0cmljcyBhdCAvbWV0cmljcywgYWxzbyB1c2VkIGZvciBoZWFsdGggY2hlY2tzLlxuICAgICAgbGlzdGVuX2FkZHJlc3MgPSBcIjo5MjUyXCJcbiAgICAgIGNvbmN1cnJlbnQgPSAke3Byb3BzLmNvbmN1cnJlbnR9XG4gIC0gcGF0aDogL3Zhci9saWIvY2xvdWQvYmluL2ZpcmV3YWxsXG4gICAgcGVybWlzc2lvbnM6IDA3NTVcbiAgICBvd25lcjogcm9vdFxuICAgIGNvbnRlbnQ6IHxcbiAgICAgICMhIC9iaW4vYmFzaFxuICAgICAgaXB0YWJsZXMgLXcgLUEgSU5QVVQgLXAgdGNwIC0tZHBvcnQgOTI1MiAtaiBBQ0NFUFRcbiAgLSBwYXRoOiAvZXRjL3N5c3RlbWQvc3lzdGVtL2dpdGxhYi1ydW5uZXItcmVnaXN0ZXIuc2VydmljZVxuICAgIHBlcm1pc3Npb25zOiAwNjQ0XG4gICAgb3duZXI6IHJvb3RcbiAgICBjb250ZW50OiB8XG4gICAgICBbVW5pdF1cbiAgICAgIERlc2NyaXB0aW9uPUdpdExhYiBSdW5uZXIgUmVnaXN0cmF0aW9uL1VucmVnaXN0cmF0aW9uXG4gICAgICBDb25kaXRpb25GaWxlSXNFeGVjdXRhYmxlPS92YXIvbGliL2dvb2dsZS9iaW4vZ2l0bGFiLXJ1bm5lclxuICAgICAgQWZ0ZXI9c3lzbG9nLnRhcmdldCBuZXR3b3JrLW9ubGluZS50YXJnZXRcbiAgICAgIFtTZXJ2aWNlXVxuICAgICAgVHlwZT1vbmVzaG90XG4gICAgICBSZW1haW5BZnRlckV4aXQ9eWVzXG4gICAgICBFeGVjU3RhcnQ9L3Zhci9saWIvZ29vZ2xlL2Jpbi9naXRsYWItcnVubmVyIHJlZ2lzdGVyIC0tbm9uLWludGVyYWN0aXZlIC0tdXJsIFwiJHtwcm9wcy5naXRsYWJVcmx9XCIgLS1leGVjdXRvciBcImRvY2tlclwiIC0tcmVnaXN0cmF0aW9uLXRva2VuICR7cHJvcHMuZ2l0bGFiVG9rZW59IC0tZG9ja2VyLWltYWdlIGFscGluZTpsYXRlc3QgLS10YWctbGlzdCBcIiR7cHJvcHMudGFncz8uam9pbignLCcpfVwiIC0tbG9ja2VkPVwiZmFsc2VcIiAtLWFjY2Vzcy1sZXZlbD1cIm5vdF9wcm90ZWN0ZWRcIiAke3RoaXMuZG9ja2VyVm9sdW1lc0xpc3QocHJvcHM/LmRvY2tlclZvbHVtZXMpfSAtLWRlc2NyaXB0aW9uIFwiQSBSdW5uZXIgb24gR0NQIEdDRSAoJHtwcm9wcy5tYWNoaW5lVHlwZX0pXCIgLS1kb2NrZXItcHJpdmlsZWdlZFxuICAgICAgRXhlY1N0b3A9L3Zhci9saWIvZ29vZ2xlL2Jpbi9naXRsYWItcnVubmVyIFwidW5yZWdpc3RlclwiIFwiLS1jb25maWdcIiBcIi9ldGMvZ2l0bGFiLXJ1bm5lci9jb25maWcudG9tbFwiIFwiLS1hbGwtcnVubmVyc1wiXG4gICAgICBbSW5zdGFsbF1cbiAgICAgIFdhbnRlZEJ5PW11bHRpLXVzZXIudGFyZ2V0XG4gIC0gcGF0aDogL2V0Yy9zeXN0ZW1kL3N5c3RlbS9naXRsYWItcnVubmVyLnNlcnZpY2VcbiAgICBwZXJtaXNzaW9uczogMDY0NFxuICAgIG93bmVyOiByb290XG4gICAgY29udGVudDogfFxuICAgICAgW1VuaXRdXG4gICAgICBEZXNjcmlwdGlvbj1HaXRMYWIgUnVubmVyXG4gICAgICBDb25kaXRpb25GaWxlSXNFeGVjdXRhYmxlPS92YXIvbGliL2dvb2dsZS9iaW4vZ2l0bGFiLXJ1bm5lclxuICAgICAgQWZ0ZXI9Z2l0bGFiLXJ1bm5lci1yZWdpc3Rlci5zZXJ2aWNlIHN5c2xvZy50YXJnZXQgbmV0d29yay1vbmxpbmUudGFyZ2V0XG4gICAgICBSZXF1aXJlcz1naXRsYWItcnVubmVyLXJlZ2lzdGVyLnNlcnZpY2VcbiAgICAgIFtTZXJ2aWNlXVxuICAgICAgU3RhcnRMaW1pdEludGVydmFsPTVcbiAgICAgIFN0YXJ0TGltaXRCdXJzdD0xMFxuICAgICAgRXhlY1N0YXJ0PS92YXIvbGliL2dvb2dsZS9iaW4vZ2l0bGFiLXJ1bm5lciBcInJ1blwiIFwiLS13b3JraW5nLWRpcmVjdG9yeVwiIFwiL2hvbWUvZ2l0bGFiLXJ1bm5lclwiIFwiLS1jb25maWdcIiBcIi9ldGMvZ2l0bGFiLXJ1bm5lci9jb25maWcudG9tbFwiIFwiLS1zZXJ2aWNlXCIgXCJnaXRsYWItcnVubmVyXCIgXCItLXN5c2xvZ1wiIFwiLS11c2VyXCIgXCJnaXRsYWItcnVubmVyXCJcbiAgICAgIFJlc3RhcnQ9YWx3YXlzXG4gICAgICBSZXN0YXJ0U2VjPTEyMFxuICAgICAgW0luc3RhbGxdXG4gICAgICBXYW50ZWRCeT1tdWx0aS11c2VyLnRhcmdldFxuICAtIHBhdGg6IC9ldGMvc3lzdGVtZC9zeXN0ZW0vZmlyZXdhbGwuc2VydmljZVxuICAgIHBlcm1pc3Npb25zOiAwNjQ0XG4gICAgb3duZXI6IHJvb3RcbiAgICBjb250ZW50OiB8XG4gICAgICBbVW5pdF1cbiAgICAgIERlc2NyaXB0aW9uPUhvc3QgZmlyZXdhbGwgY29uZmlndXJhdGlvblxuICAgICAgQ29uZGl0aW9uRmlsZUlzRXhlY3V0YWJsZT0vdmFyL2xpYi9jbG91ZC9iaW4vZmlyZXdhbGxcbiAgICAgIEFmdGVyPW5ldHdvcmstb25saW5lLnRhcmdldFxuICAgICAgW1NlcnZpY2VdXG4gICAgICBFeGVjU3RhcnQ9L3Zhci9saWIvY2xvdWQvYmluL2ZpcmV3YWxsXG4gICAgICBUeXBlPW9uZXNob3RcbiAgICAgIFtJbnN0YWxsXVxuICAgICAgV2FudGVkQnk9bXVsdGktdXNlci50YXJnZXRcblxucnVuY21kOlxuICAtIG1rZGlyIC92YXIvbGliL2dvb2dsZS90bXBcbiAgLSBta2RpciAvdmFyL2xpYi9nb29nbGUvYmluXG4gIC0gY3VybCAtTCAtLW91dHB1dCAvdmFyL2xpYi9nb29nbGUvdG1wL2dpdGxhYi1ydW5uZXIgJHtwcm9wcy5kb3dubG9hZEdpdGxhYlJ1bm5lckJpbmFyeVVybH1cbiAgLSBpbnN0YWxsIC1vIDAgLWcgMCAtbSAwNzU1IC92YXIvbGliL2dvb2dsZS90bXAvZ2l0bGFiLXJ1bm5lciAvdmFyL2xpYi9nb29nbGUvYmluL2dpdGxhYi1ydW5uZXJcbiAgLSBzeXN0ZW1jdGwgZGFlbW9uLXJlbG9hZFxuICAtIHN5c3RlbWN0bCBzdGFydCBmaXJld2FsbC5zZXJ2aWNlXG4gIC0gc3lzdGVtY3RsIHN0YXJ0IGdpdGxhYi1ydW5uZXItcmVnaXN0ZXIuc2VydmljZVxuICAtIHN5c3RlbWN0bCBzdGFydCBnaXRsYWItcnVubmVyLnNlcnZpY2VcbiAgLSBjaG1vZCAreCAvdmFyL3J1bi9kb2NrZXIuc29ja1xuXG4tLU1JTUVCT1VOREFSWS0tXG5gLFxuICAgIF07XG4gIH1cbiAgcHJpdmF0ZSBjcmVhdGVTaHV0ZHdvblNjcmlwdCgpOiBzdHJpbmdbXSB7XG4gICAgcmV0dXJuIFsnIyEvYmluL2Jhc2gnLCAnL3Zhci9saWIvZ29vZ2xlL2Jpbi9naXRsYWItcnVubmVyIHVucmVnaXN0ZXIgLS1hbGwtcnVubmVycyddO1xuICB9XG59Il19