# IM Kernel Python SDK

IM Kernel Python SDK 是一个强大的工具包，用于构建和操作基于工业模型（Industry Model）的应用。它基于工业语言和三维四层统一模型理论，为开发者提供了一套全面的
API 来创建、管理和优化复杂的工业系统模型。

## 安装

使用 pip 安装 IM Kernel Python SDK：

```bash
pip install imkernel
```

## Jupyter Notebook 支持

为了提供更好的交互式体验和便于学习，IM Kernel Python SDK 现在支持 Jupyter Notebook。

### 启动 Jupyter Notebook

安装完 SDK 后，您可以使用以下命令启动 Jupyter Notebook：

```bash
jupyter notebook
```

这将打开一个新的浏览器窗口，显示 Jupyter Notebook 的文件浏览器界面。

### 示例 Notebooks

在 `notebooks` 目录下，您可以找到几个预设的示例 notebooks：

1. `quick_start.ipynb`: 快速入门指南
2. `advanced_features.ipynb`: 高级功能演示
3. `industrial_model_creation.ipynb`: 工业模型创建教程

这些 notebooks 提供了详细的代码示例和解释，帮助您快速上手 IM Kernel Python SDK 的各项功能。

### 创建自己的 Notebook

您也可以创建新的 notebook 来开发和测试您的工业模型。在 Jupyter 界面中，点击 "New" 按钮，然后选择 "Python 3" 来创建一个新的
notebook。

## 文档

完整的 API 文档和更多示例可以在我们的[官方文档网站](https://docs.imkernel.com)上找到。

## 贡献

我们欢迎社区贡献！如果您发现了 bug 或有改进建议，请在我们的 GitHub 仓库提出 issue 或提交 pull request。

## 许可证

IM Kernel Python SDK 采用 MIT 许可证。详情请见 [LICENSE](LICENSE) 文件。

