/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.reflections.serializers;

import cdjd.com.google.common.base.Supplier;
import cdjd.com.google.common.collect.Multimap;
import cdjd.com.google.common.collect.Multimaps;
import cdjd.com.google.common.collect.SetMultimap;
import cdjd.com.google.common.collect.Sets;
import cdjd.com.google.common.io.Files;
import cdjd.com.google.gson.Gson;
import cdjd.com.google.gson.GsonBuilder;
import cdjd.com.google.gson.JsonArray;
import cdjd.com.google.gson.JsonDeserializationContext;
import cdjd.com.google.gson.JsonDeserializer;
import cdjd.com.google.gson.JsonElement;
import cdjd.com.google.gson.JsonObject;
import cdjd.com.google.gson.JsonParseException;
import cdjd.com.google.gson.JsonSerializationContext;
import cdjd.org.reflections.Reflections;
import cdjd.org.reflections.serializers.Serializer;
import cdjd.org.reflections.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JsonSerializer
implements Serializer {
    private Gson gson;

    public Reflections read(InputStream inputStream) {
        return (Reflections)this.getGson().fromJson((Reader)new InputStreamReader(inputStream), Reflections.class);
    }

    public File save(Reflections reflections, String filename) {
        try {
            File file = Utils.prepareFile(filename);
            Files.write(this.toString(reflections), file, Charset.defaultCharset());
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString(Reflections reflections) {
        return this.getGson().toJson((Object)reflections);
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter(Multimap.class, (Object)new cdjd.com.google.gson.JsonSerializer<Multimap>(){

                public JsonElement serialize(Multimap multimap, Type type, JsonSerializationContext jsonSerializationContext) {
                    return jsonSerializationContext.serialize(multimap.asMap());
                }
            }).registerTypeAdapter(Multimap.class, (Object)new JsonDeserializer<Multimap>(){

                public Multimap deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    SetMultimap map = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<String>>(){

                        @Override
                        public Set<String> get() {
                            return Sets.newHashSet();
                        }
                    });
                    for (Map.Entry entry : ((JsonObject)jsonElement).entrySet()) {
                        for (JsonElement element : (JsonArray)entry.getValue()) {
                            map.get(entry.getKey()).add(element.getAsString());
                        }
                    }
                    return map;
                }
            }).setPrettyPrinting().create();
        }
        return this.gson;
    }
}

