/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.jboss.netty.logging;

import cdjd.org.jboss.netty.logging.InternalLogger;
import cdjd.org.jboss.netty.logging.InternalLoggerFactory;
import cdjd.org.jboss.netty.logging.JdkLoggerFactory;
import cdjd.org.jboss.netty.logging.OsgiLogger;
import cdjd.org.osgi.framework.BundleContext;
import cdjd.org.osgi.framework.ServiceReference;
import cdjd.org.osgi.service.log.LogService;
import cdjd.org.osgi.util.tracker.ServiceTracker;

public class OsgiLoggerFactory
extends InternalLoggerFactory {
    private final ServiceTracker logServiceTracker;
    private final InternalLoggerFactory fallback;
    volatile LogService logService;

    public OsgiLoggerFactory(BundleContext ctx) {
        this(ctx, null);
    }

    public OsgiLoggerFactory(BundleContext ctx, InternalLoggerFactory fallback) {
        if (ctx == null) {
            throw new NullPointerException("ctx");
        }
        if (fallback == null && (fallback = InternalLoggerFactory.getDefaultFactory()) instanceof OsgiLoggerFactory) {
            fallback = new JdkLoggerFactory();
        }
        this.fallback = fallback;
        this.logServiceTracker = new ServiceTracker(ctx, "cdjd.org.osgi.service.log.LogService", null){

            public Object addingService(ServiceReference reference) {
                LogService service;
                OsgiLoggerFactory.this.logService = service = (LogService)super.addingService(reference);
                return service;
            }

            public void removedService(ServiceReference reference, Object service) {
                OsgiLoggerFactory.this.logService = null;
            }
        };
        this.logServiceTracker.open();
    }

    public InternalLoggerFactory getFallback() {
        return this.fallback;
    }

    public LogService getLogService() {
        return this.logService;
    }

    public void destroy() {
        this.logService = null;
        this.logServiceTracker.close();
    }

    public InternalLogger newInstance(String name) {
        return new OsgiLogger(this, name, this.fallback.newInstance(name));
    }
}

