/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.jboss.netty.handler.codec.string;

import cdjd.org.jboss.netty.buffer.ChannelBuffers;
import cdjd.org.jboss.netty.channel.Channel;
import cdjd.org.jboss.netty.channel.ChannelHandler;
import cdjd.org.jboss.netty.channel.ChannelHandlerContext;
import cdjd.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class StringEncoder
extends OneToOneEncoder {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof String) {
            return ChannelBuffers.copiedBuffer(ctx.getChannel().getConfig().getBufferFactory().getDefaultOrder(), (String)msg, this.charset);
        }
        return msg;
    }
}

