/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.jboss.netty.handler.codec.serialization;

import cdjd.org.jboss.netty.buffer.ChannelBuffer;
import cdjd.org.jboss.netty.buffer.ChannelBufferOutputStream;
import cdjd.org.jboss.netty.buffer.ChannelBuffers;
import cdjd.org.jboss.netty.handler.codec.serialization.CompactObjectOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class ObjectEncoderOutputStream
extends OutputStream
implements ObjectOutput {
    private final DataOutputStream out;
    private final int estimatedLength;

    public ObjectEncoderOutputStream(OutputStream out) {
        this(out, 512);
    }

    public ObjectEncoderOutputStream(OutputStream out, int estimatedLength) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        this.out = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        this.estimatedLength = estimatedLength;
    }

    public void writeObject(Object obj) throws IOException {
        ChannelBufferOutputStream bout = new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer(this.estimatedLength));
        CompactObjectOutputStream oout = new CompactObjectOutputStream(bout);
        oout.writeObject(obj);
        oout.flush();
        oout.close();
        ChannelBuffer buffer = bout.buffer();
        int objectSize = buffer.readableBytes();
        this.writeInt(objectSize);
        buffer.getBytes(0, this, objectSize);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.out.size();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    public final void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    public final void writeBytes(String s2) throws IOException {
        this.out.writeBytes(s2);
    }

    public final void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    public final void writeChars(String s2) throws IOException {
        this.out.writeChars(s2);
    }

    public final void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    public final void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    public final void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    public final void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    public final void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    public final void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }
}

