/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.jboss.netty.handler.codec.protobuf;

import cdjd.com.google.protobuf.CodedOutputStream;
import cdjd.org.jboss.netty.buffer.ChannelBuffer;
import cdjd.org.jboss.netty.buffer.ChannelBufferOutputStream;
import cdjd.org.jboss.netty.buffer.ChannelBuffers;
import cdjd.org.jboss.netty.channel.Channel;
import cdjd.org.jboss.netty.channel.ChannelHandler;
import cdjd.org.jboss.netty.channel.ChannelHandlerContext;
import cdjd.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends OneToOneEncoder {
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer body = (ChannelBuffer)msg;
        int length = body.readableBytes();
        ChannelBuffer header = channel.getConfig().getBufferFactory().getBuffer(body.order(), CodedOutputStream.computeRawVarint32Size(length));
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(new ChannelBufferOutputStream(header));
        codedOutputStream.writeRawVarint32(length);
        codedOutputStream.flush();
        return ChannelBuffers.wrappedBuffer(header, body);
    }
}

