/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.utils;

import cdjd.org.apache.zookeeper.ClientCnxn;
import cdjd.org.apache.zookeeper.WatchedEvent;
import cdjd.org.apache.zookeeper.Watcher;
import cdjd.org.apache.zookeeper.ZooKeeper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class InjectSessionExpiration {
    private static final Field cnxnField;
    private static final Field eventThreadField;
    private static final Method queueEventMethod;

    public static void injectSessionExpiration(ZooKeeper zooKeeper) {
        try {
            WatchedEvent event = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null);
            ClientCnxn clientCnxn = (ClientCnxn)cnxnField.get(zooKeeper);
            Object eventThread = eventThreadField.get(clientCnxn);
            queueEventMethod.invoke(eventThread, event);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not inject session expiration using reflection", e);
        }
    }

    static {
        Method localQueueEventMethod;
        Field localEventThreadField;
        Field localCnxnField;
        try {
            Class<?> eventThreadClass = Class.forName("cdjd.org.apache.zookeeper.ClientCnxn$EventThread");
            localCnxnField = ZooKeeper.class.getDeclaredField("cnxn");
            localCnxnField.setAccessible(true);
            localEventThreadField = ClientCnxn.class.getDeclaredField("eventThread");
            localEventThreadField.setAccessible(true);
            localQueueEventMethod = eventThreadClass.getDeclaredMethod("queueEvent", WatchedEvent.class);
            localQueueEventMethod.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not access internal ZooKeeper fields", e);
        }
        cnxnField = localCnxnField;
        eventThreadField = localEventThreadField;
        queueEventMethod = localQueueEventMethod;
    }
}

