/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.compression;

import cdjd.org.apache.arrow.vector.compression.CompressionCodec;
import cdjd.org.apache.arrow.vector.compression.NoCompressionCodec;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowBodyCompression;

public class CompressionUtil {
    private CompressionUtil() {
    }

    public static ArrowBodyCompression createBodyCompression(CompressionCodec codec) {
        switch (codec.getCodecName()) {
            case "default": {
                return NoCompressionCodec.DEFAULT_BODY_COMPRESSION;
            }
            case "LZ4_FRAME": {
                return new ArrowBodyCompression(0, 0);
            }
            case "ZSTD": {
                return new ArrowBodyCompression(1, 0);
            }
        }
        throw new IllegalArgumentException("Unknown codec: " + codec.getCodecName());
    }

    public static CompressionCodec createCodec(byte compressionType) {
        switch (compressionType) {
            case -1: {
                return NoCompressionCodec.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Compression type not supported: " + compressionType);
    }
}

