/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex.impl;

import cdjd.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import cdjd.org.apache.arrow.vector.complex.writer.TimeStampNanoWriter;
import cdjd.org.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import cdjd.org.apache.arrow.vector.holders.TimeStampNanoHolder;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.util.DateUtility;
import java.time.LocalDateTime;

public class TimeStampNanoHolderReaderImpl
extends AbstractFieldReader {
    private TimeStampNanoHolder holder;

    public TimeStampNanoHolderReaderImpl(TimeStampNanoHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPNANO;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(TimeStampNanoHolder h2) {
        h2.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeStampNanoHolder h2) {
        h2.value = this.holder.value;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        return DateUtility.getLocalDateTimeFromEpochNano(this.holder.value);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }

    @Override
    public void copyAsValue(TimeStampNanoWriter writer) {
        writer.write(this.holder);
    }
}

