/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex.impl;

import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.vector.DecimalVector;
import cdjd.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import cdjd.org.apache.arrow.vector.holders.DecimalHolder;
import cdjd.org.apache.arrow.vector.holders.NullableDecimalHolder;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.util.DecimalUtility;
import java.math.BigDecimal;

public class DecimalWriterImpl
extends AbstractFieldWriter {
    final DecimalVector vector;

    public DecimalWriterImpl(DecimalVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(DecimalHolder h2) {
        DecimalUtility.checkPrecisionAndScale(h2.precision, h2.scale, this.vector.getPrecision(), this.vector.getScale());
        this.vector.setSafe(this.idx(), h2);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableDecimalHolder h2) {
        if (h2.isSet == 1) {
            DecimalUtility.checkPrecisionAndScale(h2.precision, h2.scale, this.vector.getPrecision(), this.vector.getScale());
        }
        this.vector.setSafe(this.idx(), h2);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDecimal(long start, ArrowBuf buffer) {
        this.vector.setSafe(this.idx(), 1, start, buffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDecimal(long start, ArrowBuf buffer, ArrowType arrowType) {
        DecimalUtility.checkPrecisionAndScale(((ArrowType.Decimal)arrowType).getPrecision(), ((ArrowType.Decimal)arrowType).getScale(), this.vector.getPrecision(), this.vector.getScale());
        this.vector.setSafe(this.idx(), 1, start, buffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        this.vector.setSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeBigEndianBytesToDecimal(byte[] value, ArrowType arrowType) {
        DecimalUtility.checkPrecisionAndScale(((ArrowType.Decimal)arrowType).getPrecision(), ((ArrowType.Decimal)arrowType).getScale(), this.vector.getPrecision(), this.vector.getScale());
        this.vector.setBigEndianSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeBigEndianBytesToDecimal(byte[] value) {
        this.vector.setBigEndianSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

