/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.types.Types;
import cdjd.com.dremio.exec.expr.TypeHelper;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.google.common.base.Preconditions;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.vector.BaseValueVectorHelper;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.ValueVectorHelper;
import cdjd.org.apache.arrow.vector.complex.StructVector;
import cdjd.org.apache.arrow.vector.types.SerializedFieldHelper;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.util.BasicTypeHelper;
import java.util.HashSet;
import java.util.List;

public class StructVectorHelper
implements ValueVectorHelper {
    private StructVector structVector;

    public StructVectorHelper(StructVector vector) {
        this.structVector = vector;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, ArrowBuf buf) {
        this.structVector.clear();
        List<UserBitShared.SerializedField> childList = metadata.getChildList();
        int bufOffset = 0;
        long readableBytes = buf.readableBytes();
        this.structVector.valueCount = metadata.getValueCount();
        UserBitShared.SerializedField child = childList.get(0);
        Field fieldDef = SerializedFieldHelper.create(child);
        Preconditions.checkState(fieldDef.getName().equals("$bits$"), "expected validity vector: %s", (Object)fieldDef);
        bufOffset = this.loadValidityBuffer(child, buf);
        HashSet<String> children = new HashSet<String>();
        for (Field childField : this.structVector.getField().getChildren()) {
            children.add(childField.getName().toLowerCase());
        }
        List<UserBitShared.SerializedField> fields = childList.subList(1, childList.size());
        for (UserBitShared.SerializedField child2 : fields) {
            Field fieldDef2 = SerializedFieldHelper.create(child2);
            FieldVector vector = this.structVector.getChild(fieldDef2.getName());
            if (vector == null) {
                vector = BasicTypeHelper.getNewVector(fieldDef2, this.structVector.allocator);
                this.structVector.putChild(fieldDef2.getName(), vector);
            }
            children.remove(fieldDef2.getName().toLowerCase());
            bufOffset = this.load(buf, bufOffset, child2, vector);
        }
        for (String remaingChild : children) {
            FieldVector childVector = this.structVector.getChild(remaingChild);
            childVector.allocateNew();
            childVector.setValueCount(metadata.getValueCount());
        }
        Preconditions.checkState((long)bufOffset == readableBytes, "buffer offset %s not equal to readable bytes %s", bufOffset, readableBytes);
    }

    private int loadValidityBuffer(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        int valueCount = metadata.getValueCount();
        int actualLength = metadata.getBufferLength();
        int expectedLength = BaseValueVectorHelper.getValidityBufferSizeFromCount(valueCount);
        assert (expectedLength == actualLength) : String.format("Expected to load %d bytes in validity buffer but actually loaded %d bytes", expectedLength, actualLength);
        this.structVector.validityBuffer = buffer.slice(0L, actualLength);
        this.structVector.validityBuffer.writerIndex(actualLength);
        this.structVector.validityBuffer.retain(1);
        return actualLength;
    }

    private int load(ArrowBuf buf, int bufOffset, UserBitShared.SerializedField child, FieldVector vector) {
        if (child.getValueCount() == 0) {
            vector.clear();
        } else {
            TypeHelper.load(vector, child, buf.slice(bufOffset, child.getBufferLength()));
        }
        return bufOffset += child.getBufferLength();
    }

    @Override
    public void materialize(Field field) {
        List<Field> children = field.getChildren();
        for (Field child : children) {
            FieldVector v = TypeHelper.getNewVector(child, this.structVector.allocator, this.structVector.callBack);
            TypeHelper.getHelper(v).ifPresent(t -> t.materialize(child));
            this.structVector.putChild(child.getName(), v);
        }
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        int bufferSize = this.structVector.getBufferSize();
        UserBitShared.SerializedField.Builder b = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName(this.structVector.getField().getName())).setMajorType(Types.optional(TypeProtos.MinorType.STRUCT)).setBufferLength(bufferSize).setValueCount(this.structVector.valueCount);
        b.addChild(this.buildValidityMetadata());
        int expectedBufferSize = BaseValueVectorHelper.getValidityBufferSizeFromCount(this.structVector.valueCount);
        for (ValueVector valueVector : this.structVector.getChildren()) {
            UserBitShared.SerializedField metadata = TypeHelper.getMetadata(valueVector);
            expectedBufferSize += metadata.getBufferLength();
            b.addChild(metadata);
        }
        Preconditions.checkState(expectedBufferSize == bufferSize, "Invalid buffer count: %s != %s", expectedBufferSize, bufferSize);
        return b.build();
    }

    private UserBitShared.SerializedField buildValidityMetadata() {
        UserBitShared.SerializedField.Builder validityBuilder = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName("$bits$").build()).setValueCount(this.structVector.valueCount).setBufferLength(BaseValueVectorHelper.getValidityBufferSizeFromCount(this.structVector.valueCount)).setMajorType(Types.required(TypeProtos.MinorType.BIT));
        return validityBuilder.build();
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return null;
    }

    @Override
    public void loadFromValidityAndDataBuffers(UserBitShared.SerializedField metadata, ArrowBuf dataBuffer, ArrowBuf validityBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadData(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        throw new UnsupportedOperationException();
    }
}

