/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.types.Types;
import cdjd.com.dremio.exec.expr.TypeHelper;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.google.common.base.Preconditions;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.ValueVectorHelper;
import cdjd.org.apache.arrow.vector.complex.NonNullableStructVector;
import cdjd.org.apache.arrow.vector.complex.StructVector;
import cdjd.org.apache.arrow.vector.types.SerializedFieldHelper;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.util.BasicTypeHelper;
import java.util.List;

public class NonNullableStructVectorHelper
implements ValueVectorHelper {
    private NonNullableStructVector structVector;

    public NonNullableStructVectorHelper(NonNullableStructVector vector) {
        if (vector instanceof StructVector) {
            throw new IllegalArgumentException("Invalid vector: " + vector);
        }
        this.structVector = vector;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, ArrowBuf buf) {
        List<UserBitShared.SerializedField> fields = metadata.getChildList();
        this.structVector.valueCount = metadata.getValueCount();
        int bufOffset = 0;
        for (UserBitShared.SerializedField child : fields) {
            Field fieldDef = SerializedFieldHelper.create(child);
            FieldVector vector = this.structVector.getChild(fieldDef.getName());
            if (vector == null) {
                vector = BasicTypeHelper.getNewVector(fieldDef, this.structVector.allocator);
                this.structVector.putChild(fieldDef.getName(), vector);
            }
            if (child.getValueCount() == 0) {
                vector.clear();
            } else {
                TypeHelper.load(vector, child, buf.slice(bufOffset, child.getBufferLength()));
            }
            bufOffset += child.getBufferLength();
        }
        Preconditions.checkState((long)bufOffset == buf.capacity());
    }

    @Override
    public void materialize(Field field) {
        List<Field> children = field.getChildren();
        for (Field child : children) {
            FieldVector v = TypeHelper.getNewVector(child, this.structVector.allocator, this.structVector.callBack);
            TypeHelper.getHelper(v).ifPresent(t -> t.materialize(child));
            this.structVector.putChild(child.getName(), v);
        }
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        UserBitShared.SerializedField.Builder b = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName(this.structVector.getField().getName())).setMajorType(Types.optional(TypeProtos.MinorType.STRUCT)).setBufferLength(this.structVector.getBufferSize()).setValueCount(this.structVector.valueCount);
        for (ValueVector valueVector : this.structVector.getChildren()) {
            b.addChild(TypeHelper.getMetadata(valueVector));
        }
        return b.build();
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return null;
    }

    @Override
    public void loadFromValidityAndDataBuffers(UserBitShared.SerializedField metadata, ArrowBuf dataBuffer, ArrowBuf validityBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadData(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        throw new UnsupportedOperationException();
    }
}

