/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.types.Types;
import cdjd.com.dremio.common.util.MajorTypeHelper;
import cdjd.com.dremio.exec.expr.TypeHelper;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import cdjd.org.apache.arrow.vector.complex.BaseRepeatedValueVectorHelper;
import cdjd.org.apache.arrow.vector.complex.ListVector;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;

public class ListVectorHelper
extends BaseRepeatedValueVectorHelper<ListVector> {
    private ListVector listVector;

    public ListVectorHelper(ListVector vector) {
        super(vector);
        this.listVector = vector;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        this.listVector.clear();
        UserBitShared.SerializedField offsetMetadata = metadata.getChild(0);
        int offsetLength = offsetMetadata.getBufferLength();
        this.loadOffsetBuffer(offsetMetadata, buffer);
        UserBitShared.SerializedField bitMetadata = metadata.getChild(1);
        int bitLength = bitMetadata.getBufferLength();
        this.loadValidityBuffer(bitMetadata, buffer.slice(offsetLength, bitLength));
        UserBitShared.SerializedField vectorMetadata = metadata.getChild(2);
        if (this.listVector.getDataVector() == BaseRepeatedValueVector.DEFAULT_DATA_VECTOR) {
            this.listVector.addOrGetVector(FieldType.nullable(MajorTypeHelper.getArrowMinorType(vectorMetadata.getMajorType().getMinorType()).getType()));
        }
        int vectorLength = vectorMetadata.getBufferLength();
        TypeHelper.load(this.listVector.vector, vectorMetadata, buffer.slice(offsetLength + bitLength, vectorLength));
        this.listVector.setLastSet(metadata.getValueCount() - 1);
        this.listVector.valueCount = metadata.getValueCount();
    }

    @Override
    protected void loadDataAndPossiblyOffsetBuffer(UserBitShared.SerializedField field, ArrowBuf buf) {
        throw new UnsupportedOperationException();
    }

    private void loadValidityBuffer(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        int valueCount = metadata.getValueCount();
        int actualLength = metadata.getBufferLength();
        int expectedLength = ListVectorHelper.getValidityBufferSizeFromCount(valueCount);
        assert (expectedLength == actualLength) : String.format("Expected to load %d bytes in validity buffer but actually loaded %d bytes", expectedLength, actualLength);
        this.listVector.validityBuffer = buffer.slice(0L, actualLength);
        this.listVector.validityBuffer.writerIndex(actualLength);
        this.listVector.validityBuffer.retain(1);
    }

    @Override
    public void materialize(Field field) {
        if (field.getChildren().size() == 0) {
            return;
        }
        Field innerField = field.getChildren().get(0);
        Object innerVector = this.listVector.addOrGetVector(innerField.getFieldType()).getVector();
        TypeHelper.getHelper(innerVector).ifPresent(t -> t.materialize(innerField));
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return UserBitShared.SerializedField.newBuilder().setMajorType(TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.LIST).setMode(TypeProtos.DataMode.OPTIONAL).build()).setNamePart(UserBitShared.NamePart.newBuilder().setName(this.listVector.getField().getName())).setValueCount(this.listVector.getValueCount()).setBufferLength(this.listVector.getBufferSize()).addChild(this.buildOffsetMetadata()).addChild(this.buildValidityMetadata()).addChild(TypeHelper.getMetadata(this.listVector.vector));
    }

    @Override
    protected UserBitShared.SerializedField buildValidityMetadata() {
        UserBitShared.SerializedField.Builder validityBuilder = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName("$bits$").build()).setValueCount(this.listVector.valueCount).setBufferLength(ListVectorHelper.getValidityBufferSizeFromCount(this.listVector.valueCount)).setMajorType(Types.required(TypeProtos.MinorType.BIT));
        return validityBuilder.build();
    }
}

