/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector;

import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.util.Collections2;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.TypeLayout;
import cdjd.org.apache.arrow.vector.VectorSchemaRoot;
import cdjd.org.apache.arrow.vector.compression.CompressionCodec;
import cdjd.org.apache.arrow.vector.compression.CompressionUtil;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VectorLoader {
    private final VectorSchemaRoot root;

    public VectorLoader(VectorSchemaRoot root) {
        this.root = root;
    }

    public void load(ArrowRecordBatch recordBatch) {
        Iterator<ArrowBuf> buffers = recordBatch.getBuffers().iterator();
        Iterator<ArrowFieldNode> nodes = recordBatch.getNodes().iterator();
        CompressionCodec codec = CompressionUtil.createCodec(recordBatch.getBodyCompression().getCodec());
        for (FieldVector fieldVector : this.root.getFieldVectors()) {
            this.loadBuffers(fieldVector, fieldVector.getField(), buffers, nodes, codec);
        }
        this.root.setRowCount(recordBatch.getLength());
        if (nodes.hasNext() || buffers.hasNext()) {
            throw new IllegalArgumentException("not all nodes and buffers were consumed. nodes: " + Collections2.toList(nodes).toString() + " buffers: " + Collections2.toList(buffers).toString());
        }
    }

    private void loadBuffers(FieldVector vector, Field field, Iterator<ArrowBuf> buffers, Iterator<ArrowFieldNode> nodes, CompressionCodec codec) {
        Preconditions.checkArgument(nodes.hasNext(), "no more field nodes for for field %s and vector %s", (Object)field, (Object)vector);
        ArrowFieldNode fieldNode = nodes.next();
        int bufferLayoutCount = TypeLayout.getTypeBufferCount(field.getType());
        ArrayList<ArrowBuf> ownBuffers = new ArrayList<ArrowBuf>(bufferLayoutCount);
        for (int j = 0; j < bufferLayoutCount; ++j) {
            ArrowBuf nextBuf = buffers.next();
            ownBuffers.add(codec.decompress(vector.getAllocator(), nextBuf));
        }
        try {
            vector.loadFieldBuffers(fieldNode, ownBuffers);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not load buffers for field " + field + ". error message: " + e.getMessage(), e);
        }
        List<Field> children = field.getChildren();
        if (children.size() > 0) {
            List<FieldVector> childrenFromFields = vector.getChildrenFromFields();
            Preconditions.checkArgument(children.size() == childrenFromFields.size(), "should have as many children as in the schema: found %s expected %s", childrenFromFields.size(), children.size());
            for (int i = 0; i < childrenFromFields.size(); ++i) {
                Field child = children.get(i);
                FieldVector fieldVector = childrenFromFields.get(i);
                this.loadBuffers(fieldVector, child, buffers, nodes, codec);
            }
        }
    }
}

