/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.types.Types;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.google.common.base.Preconditions;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.vector.BitVector;
import cdjd.org.apache.arrow.vector.FixedWidthVectorHelper;

public class ValidityVectorHelper
extends FixedWidthVectorHelper<BitVector> {
    private BitVector vector;

    public ValidityVectorHelper(BitVector vector) {
        super(vector);
        this.vector = vector;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        Preconditions.checkArgument(this.vector.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", (Object)this.vector.getName(), (Object)metadata);
        int valueCount = metadata.getValueCount();
        int expectedLength = BitVector.getValidityBufferSizeFromCount(valueCount);
        int actualLength = metadata.getBufferLength();
        assert (expectedLength == actualLength) : "expected and actual buffer sizes do not match";
        this.vector.clear();
        this.vector.valueBuffer = buffer.slice(0L, actualLength);
        this.vector.valueBuffer.writerIndex(actualLength);
        this.vector.valueBuffer.retain();
        this.vector.valueCount = valueCount;
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        UserBitShared.SerializedField.Builder builder = super.getMetadataBuilder();
        return builder.setMajorType(Types.required(TypeProtos.MinorType.BIT));
    }
}

