/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector;

import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.BitVectorHelper;
import cdjd.org.apache.arrow.vector.NullCheckingForGet;
import cdjd.org.apache.arrow.vector.TimeStampVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.complex.impl.TimeStampSecReaderImpl;
import cdjd.org.apache.arrow.vector.complex.reader.FieldReader;
import cdjd.org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import cdjd.org.apache.arrow.vector.holders.TimeStampSecHolder;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.DateUtility;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

public final class TimeStampSecVector
extends TimeStampVector {
    private final FieldReader reader = new TimeStampSecReaderImpl(this);

    public TimeStampSecVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TIMESTAMPSEC.getType()), allocator);
    }

    public TimeStampSecVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, fieldType, allocator);
    }

    public TimeStampSecVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPSEC;
    }

    public void get(int index, NullableTimeStampSecHolder holder) {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong((long)index * 8L);
    }

    @Override
    public LocalDateTime getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        long secs = this.valueBuffer.getLong((long)index * 8L);
        long millis = TimeUnit.SECONDS.toMillis(secs);
        return DateUtility.getLocalDateTimeFromEpochMilli(millis);
    }

    public void set(int index, NullableTimeStampSecHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TimeStampSecHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, NullableTimeStampSecHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeStampSecHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        TimeStampSecVector to = new TimeStampSecVector(ref, this.field.getFieldType(), allocator);
        return new TimeStampVector.TransferImpl(this, to);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TimeStampVector.TransferImpl(this, (TimeStampSecVector)to);
    }
}

