/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.typesafe.config.impl;

import cdjd.com.typesafe.config.ConfigOrigin;
import cdjd.com.typesafe.config.ConfigRenderOptions;
import cdjd.com.typesafe.config.ConfigValueType;
import cdjd.com.typesafe.config.impl.AbstractConfigValue;
import cdjd.com.typesafe.config.impl.ConfigImplUtil;
import cdjd.com.typesafe.config.impl.SerializedConfigValue;
import java.io.ObjectStreamException;
import java.io.Serializable;

final class ConfigString
extends AbstractConfigValue
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String value;

    ConfigString(ConfigOrigin origin, String value) {
        super(origin);
        this.value = value;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.STRING;
    }

    @Override
    public String unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        return this.value;
    }

    @Override
    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        String rendered = options.getJson() ? ConfigImplUtil.renderJsonString(this.value) : ConfigImplUtil.renderStringUnquotedIfPossible(this.value);
        sb.append(rendered);
    }

    @Override
    protected ConfigString newCopy(ConfigOrigin origin) {
        return new ConfigString(origin, this.value);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

