/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.typesafe.config.impl;

import cdjd.com.typesafe.config.ConfigException;
import cdjd.com.typesafe.config.ConfigObject;
import cdjd.com.typesafe.config.ConfigOrigin;
import cdjd.com.typesafe.config.ConfigRenderOptions;
import cdjd.com.typesafe.config.ConfigValueType;
import cdjd.com.typesafe.config.impl.AbstractConfigValue;
import cdjd.com.typesafe.config.impl.ConfigReference;
import cdjd.com.typesafe.config.impl.ConfigString;
import cdjd.com.typesafe.config.impl.DefaultTransformer;
import cdjd.com.typesafe.config.impl.Path;
import cdjd.com.typesafe.config.impl.ResolveContext;
import cdjd.com.typesafe.config.impl.ResolveStatus;
import cdjd.com.typesafe.config.impl.SimpleConfigList;
import cdjd.com.typesafe.config.impl.SimpleConfigOrigin;
import cdjd.com.typesafe.config.impl.SubstitutionExpression;
import cdjd.com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConfigConcatenation
extends AbstractConfigValue
implements Unmergeable {
    private final List<AbstractConfigValue> pieces;

    ConfigConcatenation(ConfigOrigin origin, List<AbstractConfigValue> pieces) {
        super(origin);
        this.pieces = pieces;
        if (pieces.size() < 2) {
            throw new ConfigException.BugOrBroken("Created concatenation with less than 2 items: " + this);
        }
        boolean hadUnmergeable = false;
        for (AbstractConfigValue p : pieces) {
            if (p instanceof ConfigConcatenation) {
                throw new ConfigException.BugOrBroken("ConfigConcatenation should never be nested: " + this);
            }
            if (!(p instanceof Unmergeable)) continue;
            hadUnmergeable = true;
        }
        if (!hadUnmergeable) {
            throw new ConfigException.BugOrBroken("Created concatenation without an unmergeable in it: " + this);
        }
    }

    private ConfigException.NotResolved notResolved() {
        return new ConfigException.NotResolved("need to Config#resolve(), see the API docs for Config#resolve(); substitution not resolved: " + this);
    }

    @Override
    public ConfigValueType valueType() {
        throw this.notResolved();
    }

    @Override
    public Object unwrapped() {
        throw this.notResolved();
    }

    @Override
    protected ConfigConcatenation newCopy(ConfigOrigin newOrigin) {
        return new ConfigConcatenation(newOrigin, this.pieces);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return false;
    }

    public Collection<ConfigConcatenation> unmergedValues() {
        return Collections.singleton(this);
    }

    private static void join(ArrayList<AbstractConfigValue> builder, AbstractConfigValue origRight) {
        AbstractConfigValue left = builder.get(builder.size() - 1);
        AbstractConfigValue right = origRight;
        if (left instanceof ConfigObject && right instanceof SimpleConfigList) {
            left = DefaultTransformer.transform(left, ConfigValueType.LIST);
        } else if (left instanceof SimpleConfigList && right instanceof ConfigObject) {
            right = DefaultTransformer.transform(right, ConfigValueType.LIST);
        }
        AbstractConfigValue joined = null;
        if (left instanceof ConfigObject && right instanceof ConfigObject) {
            joined = right.withFallback(left);
        } else if (left instanceof SimpleConfigList && right instanceof SimpleConfigList) {
            joined = ((SimpleConfigList)left).concatenate((SimpleConfigList)right);
        } else {
            if (left instanceof ConfigConcatenation || right instanceof ConfigConcatenation) {
                throw new ConfigException.BugOrBroken("unflattened ConfigConcatenation");
            }
            if (!(left instanceof Unmergeable) && !(right instanceof Unmergeable)) {
                String s1 = left.transformToString();
                String s2 = right.transformToString();
                if (s1 == null || s2 == null) {
                    throw new ConfigException.WrongType(left.origin(), "Cannot concatenate object or list with a non-object-or-list, " + left + " and " + right + " are not compatible");
                }
                ConfigOrigin joinedOrigin = SimpleConfigOrigin.mergeOrigins(left.origin(), right.origin());
                joined = new ConfigString(joinedOrigin, s1 + s2);
            }
        }
        if (joined == null) {
            builder.add(right);
        } else {
            builder.remove(builder.size() - 1);
            builder.add(joined);
        }
    }

    static List<AbstractConfigValue> consolidate(List<AbstractConfigValue> pieces) {
        if (pieces.size() < 2) {
            return pieces;
        }
        ArrayList<AbstractConfigValue> flattened = new ArrayList<AbstractConfigValue>(pieces.size());
        for (AbstractConfigValue v : pieces) {
            if (v instanceof ConfigConcatenation) {
                flattened.addAll(((ConfigConcatenation)v).pieces);
                continue;
            }
            flattened.add(v);
        }
        ArrayList<AbstractConfigValue> consolidated = new ArrayList<AbstractConfigValue>(flattened.size());
        for (AbstractConfigValue v : flattened) {
            if (consolidated.isEmpty()) {
                consolidated.add(v);
                continue;
            }
            ConfigConcatenation.join(consolidated, v);
        }
        return consolidated;
    }

    static AbstractConfigValue concatenate(List<AbstractConfigValue> pieces) {
        List<AbstractConfigValue> consolidated = ConfigConcatenation.consolidate(pieces);
        if (consolidated.isEmpty()) {
            return null;
        }
        if (consolidated.size() == 1) {
            return consolidated.get(0);
        }
        ConfigOrigin mergedOrigin = SimpleConfigOrigin.mergeOrigins(consolidated);
        return new ConfigConcatenation(mergedOrigin, consolidated);
    }

    @Override
    AbstractConfigValue resolveSubstitutions(ResolveContext context) throws AbstractConfigValue.NotPossibleToResolve {
        ArrayList<AbstractConfigValue> resolved = new ArrayList<AbstractConfigValue>(this.pieces.size());
        for (AbstractConfigValue p : this.pieces) {
            AbstractConfigValue r = context.unrestricted().resolve(p);
            if (r == null) continue;
            resolved.add(r);
        }
        List<AbstractConfigValue> joined = ConfigConcatenation.consolidate(resolved);
        if (joined.size() > 1 && context.options().getAllowUnresolved()) {
            return new ConfigConcatenation(this.origin(), joined);
        }
        if (joined.size() != 1) {
            throw new ConfigException.BugOrBroken("Resolved list should always join to exactly one value, not " + joined);
        }
        return joined.get(0);
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigConcatenation relativized(Path prefix) {
        ArrayList<AbstractConfigValue> newPieces = new ArrayList<AbstractConfigValue>();
        for (AbstractConfigValue p : this.pieces) {
            newPieces.add(p.relativized(prefix));
        }
        return new ConfigConcatenation(this.origin(), newPieces);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConfigConcatenation;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ConfigConcatenation) {
            return this.canEqual(other) && ((Object)this.pieces).equals(((ConfigConcatenation)other).pieces);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.pieces).hashCode();
    }

    @Override
    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        for (AbstractConfigValue p : this.pieces) {
            p.render(sb, indent, atRoot, options);
        }
    }

    static List<AbstractConfigValue> valuesFromPieces(ConfigOrigin origin, List<Object> pieces) {
        ArrayList<AbstractConfigValue> values = new ArrayList<AbstractConfigValue>(pieces.size());
        for (Object p : pieces) {
            if (p instanceof SubstitutionExpression) {
                values.add(new ConfigReference(origin, (SubstitutionExpression)p));
                continue;
            }
            if (p instanceof String) {
                values.add(new ConfigString(origin, (String)p));
                continue;
            }
            throw new ConfigException.BugOrBroken("Unexpected piece " + p);
        }
        return values;
    }
}

