/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.github.rollingmetrics.histogram.accumulator;

import cdjd.com.codahale.metrics.Snapshot;
import cdjd.com.github.rollingmetrics.histogram.accumulator.Accumulator;
import cdjd.com.github.rollingmetrics.histogram.util.HistogramUtil;
import cdjd.com.github.rollingmetrics.histogram.util.Printer;
import cdjd.org.HdrHistogram.Histogram;
import cdjd.org.HdrHistogram.Recorder;
import java.util.function.Function;

public class ResetOnSnapshotAccumulator
implements Accumulator {
    private final Recorder recorder;
    private Histogram intervalHistogram;

    public ResetOnSnapshotAccumulator(Recorder recorder) {
        this.recorder = recorder;
        this.intervalHistogram = recorder.getIntervalHistogram();
    }

    @Override
    public void recordSingleValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) {
        this.recorder.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    @Override
    public final synchronized Snapshot getSnapshot(Function<Histogram, Snapshot> snapshotTaker) {
        this.intervalHistogram = this.recorder.getIntervalHistogram(this.intervalHistogram);
        return HistogramUtil.getSnapshot(this.intervalHistogram, snapshotTaker);
    }

    @Override
    public int getEstimatedFootprintInBytes() {
        return this.intervalHistogram.getEstimatedFootprintInBytes() * 2;
    }

    public String toString() {
        return "ResetOnSnapshotAccumulator{intervalHistogram=" + Printer.histogramToString(this.intervalHistogram) + '}';
    }
}

