/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.api.config;

import cdjd.com.fasterxml.jackson.annotation.JsonCreator;
import cdjd.com.fasterxml.jackson.annotation.JsonProperty;
import cdjd.com.google.common.base.Objects;
import java.util.concurrent.TimeUnit;

public class RefreshConfiguration {
    private final boolean enabled;
    private final long refreshIntervalMS;

    @JsonCreator
    public RefreshConfiguration(@JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="period") long refreshInterval, @JsonProperty(value="unit") TimeUnit unit) {
        this.enabled = enabled;
        this.refreshIntervalMS = unit.toMillis(refreshInterval);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getIntervalMS() {
        return this.refreshIntervalMS;
    }

    public int hashCode() {
        return Objects.hashCode(this.enabled, this.refreshIntervalMS);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RefreshConfiguration)) {
            return false;
        }
        RefreshConfiguration that = (RefreshConfiguration)obj;
        return this.enabled == that.enabled && this.refreshIntervalMS == that.refreshIntervalMS;
    }
}

