/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.api.config;

import cdjd.com.dremio.telemetry.api.config.RefreshConfiguration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoRefreshConfigurator<T> {
    private static final Logger logger = LoggerFactory.getLogger(AutoRefreshConfigurator.class);
    private static final long DEFAULT_MINIMUM_REFRESH_FREQUENCY = TimeUnit.SECONDS.toMillis(90L);
    private final Provider<CompleteRefreshConfig<T>> getter;
    private final long minRefreshIntervalMS;
    private volatile boolean refreshEnabled = true;
    private volatile long refreshIntervalMS;
    private volatile ValueChangeDetector<T> trigger;
    private volatile Thread refreshThread;

    public AutoRefreshConfigurator(Provider<CompleteRefreshConfig<T>> getter, Consumer<T> listener) {
        this(getter, listener, DEFAULT_MINIMUM_REFRESH_FREQUENCY);
    }

    public AutoRefreshConfigurator(Provider<CompleteRefreshConfig<T>> getter, Consumer<T> listener, long minRefreshIntervalMS) {
        this.getter = getter;
        this.refreshIntervalMS = this.minRefreshIntervalMS = minRefreshIntervalMS;
        this.trigger = new ValueChangeDetector<Object>(listener::accept);
        this.refreshOnce();
        this.refreshThread = new Thread(this::refreshContinually, "config-refresh");
        this.refreshThread.setDaemon(true);
        this.refreshThread.start();
    }

    private void refreshContinually() {
        try {
            while (this.refreshEnabled) {
                Thread.sleep(this.refreshIntervalMS);
                this.refreshOnce();
            }
        }
        catch (InterruptedException ex) {
            logger.info("Refresh thread interrupted, exiting.", ex);
            return;
        }
    }

    private void refreshOnce() {
        CompleteRefreshConfig newState = (CompleteRefreshConfig)this.getter.get();
        if (newState == null) {
            return;
        }
        RefreshConfiguration refreshConf = newState.getRefreshConfiguration();
        if (refreshConf != null) {
            this.refreshEnabled = refreshConf.isEnabled();
            long proposedRefreshMs = refreshConf.getIntervalMS();
            if (proposedRefreshMs < this.minRefreshIntervalMS) {
                logger.warn("Requested configuration refresh frequency {}ms. Adjusting to minimum of {}ms.", (Object)proposedRefreshMs, (Object)this.minRefreshIntervalMS);
                this.refreshIntervalMS = this.minRefreshIntervalMS;
            } else {
                this.refreshIntervalMS = proposedRefreshMs;
            }
        } else {
            logger.warn("Could not detect refresh settings. Continuing to refresh at {}s intervals.", (Object)TimeUnit.MILLISECONDS.toSeconds(this.refreshIntervalMS));
        }
        this.trigger.checkNewValue(newState.getUserConfig());
    }

    public static class ValueChangeDetector<T> {
        private boolean prevIsNull = true;
        private T lastValue;
        private final Consumer<T> reaction;

        public ValueChangeDetector(Consumer<T> reaction) {
            this.reaction = reaction;
        }

        public void checkNewValue(T newVal) {
            if (newVal == null) {
                if (!this.prevIsNull) {
                    this.reaction.accept(null);
                    this.prevIsNull = true;
                }
                return;
            }
            int h2 = newVal.hashCode();
            if (!newVal.equals(this.lastValue) || this.prevIsNull) {
                this.lastValue = newVal;
                this.prevIsNull = false;
                this.reaction.accept(newVal);
            }
        }

        public T getLastValue() {
            return this.lastValue;
        }
    }

    public static class CompleteRefreshConfig<T> {
        private final RefreshConfiguration refreshConfiguration;
        private final T userConfig;

        public CompleteRefreshConfig(RefreshConfiguration refreshConfiguration, T userConfig) {
            this.refreshConfiguration = refreshConfiguration;
            this.userConfig = userConfig;
        }

        public T getUserConfig() {
            return this.userConfig;
        }

        public RefreshConfiguration getRefreshConfiguration() {
            return this.refreshConfiguration;
        }
    }
}

