/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.ssl;

import cdjd.com.dremio.ssl.SSLConfig;
import cdjd.com.dremio.ssl.SSLEngineFactory;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.io.netty.buffer.ByteBufAllocator;
import cdjd.io.netty.handler.ssl.ClientAuth;
import cdjd.io.netty.handler.ssl.OpenSsl;
import cdjd.io.netty.handler.ssl.SslContext;
import cdjd.io.netty.handler.ssl.SslContextBuilder;
import cdjd.io.netty.handler.ssl.SslProvider;
import cdjd.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLEngineFactoryImpl
implements SSLEngineFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLEngineFactoryImpl.class);
    private static final String SSL_PROVIDER_PROPERTY = "dremio.ssl.provider";
    private static final String DEFAULT_SSL_PROVIDER = OpenSsl.isAvailable() ? SslProvider.OPENSSL.name() : SslProvider.JDK.name();
    private static final SslProvider SSL_PROVIDER = SslProvider.valueOf(System.getProperty("dremio.ssl.provider", DEFAULT_SSL_PROVIDER));
    private static final String SSL_PROTOCOLS_PROPERTY = "dremio.ssl.protocols";
    private static final String DEFAULT_SSL_PROTOCOLS = "TLSv1.2";
    private static final String[] SSL_PROTOCOLS = System.getProperty("dremio.ssl.protocols", "TLSv1.2").split(",");
    private static final String SSL_CIPHERS_PROPERTY = "dremio.ssl.ciphers";
    private static final Iterable<String> SSL_CIPHERS;
    private final SSLConfig sslConfig;
    private final KeyManagerFactory keyManagerFactory;
    private final TrustManagerFactory trustManagerFactory;

    private SSLEngineFactoryImpl(SSLConfig sslConfig) throws SSLException {
        this.sslConfig = sslConfig;
        try {
            this.keyManagerFactory = this.newKeyManagerFactory();
            this.trustManagerFactory = this.newTrustManagerFactory();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new SSLException(e);
        }
    }

    private KeyManagerFactory newKeyManagerFactory() throws GeneralSecurityException, IOException {
        if (this.sslConfig.getKeyStorePath() == "") {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance(this.sslConfig.getKeyStoreType());
        try (FileInputStream stream = new FileInputStream(this.sslConfig.getKeyStorePath());){
            keyStore.load(stream, this.sslConfig.getKeyStorePassword().toCharArray());
        }
        if (keyStore.size() == 0) {
            throw new IllegalArgumentException("Key store has no entries");
        }
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore, this.sslConfig.getKeyPassword().toCharArray());
        return factory;
    }

    private TrustManagerFactory newTrustManagerFactory() throws GeneralSecurityException, IOException {
        KeyStore trustStore;
        if (this.sslConfig.getTrustStorePath() == "") {
            trustStore = null;
        } else {
            trustStore = KeyStore.getInstance(this.sslConfig.getTrustStoreType());
            try (FileInputStream stream = new FileInputStream(this.sslConfig.getTrustStorePath());){
                trustStore.load(stream, this.sslConfig.getTrustStorePassword().toCharArray());
            }
        }
        TrustManagerFactory factory = this.sslConfig.disablePeerVerification() ? InsecureTrustManagerFactory.INSTANCE : TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(trustStore);
        return factory;
    }

    @Override
    public SslContextBuilder newServerContextBuilder() throws SSLException {
        return SslContextBuilder.forServer(this.keyManagerFactory).trustManager(this.trustManagerFactory).clientAuth(this.sslConfig.disablePeerVerification() ? ClientAuth.OPTIONAL : ClientAuth.REQUIRE).sslProvider(SSL_PROVIDER).protocols(SSL_PROTOCOLS).ciphers(SSL_CIPHERS);
    }

    @Override
    public SSLEngine newServerEngine(ByteBufAllocator allocator, String peerHost, int peerPort) throws SSLException {
        SslContext sslContext = this.newServerContextBuilder().build();
        SSLEngine engine = sslContext.newEngine(allocator, peerHost, peerPort);
        try {
            engine.setEnableSessionCreation(true);
        }
        catch (UnsupportedOperationException ignored) {
            logger.trace("Session creation not enabled", ignored);
        }
        return engine;
    }

    @Override
    public SslContextBuilder newClientContextBuilder() throws SSLException {
        return SslContextBuilder.forClient().keyManager(this.keyManagerFactory).trustManager(this.trustManagerFactory).sslProvider(SSL_PROVIDER).protocols(SSL_PROTOCOLS).ciphers(SSL_CIPHERS);
    }

    @Override
    public SSLEngine newClientEngine(ByteBufAllocator allocator, String peerHost, int peerPort) throws SSLException {
        SslContext sslContext = this.newClientContextBuilder().build();
        SSLEngine engine = sslContext.newEngine(allocator, peerHost, peerPort);
        SSLParameters sslParameters = engine.getSSLParameters();
        sslParameters.setServerNames(Collections.singletonList(new SNIHostName(peerHost)));
        if (!this.sslConfig.disableHostVerification()) {
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        }
        engine.setSSLParameters(sslParameters);
        try {
            engine.setEnableSessionCreation(true);
        }
        catch (UnsupportedOperationException ignored) {
            logger.trace("Session creation not enabled", ignored);
        }
        return engine;
    }

    public static Optional<SSLEngineFactory> create(Optional<SSLConfig> sslConfig) throws SSLException {
        return sslConfig.isPresent() ? Optional.of(new SSLEngineFactoryImpl(sslConfig.get())) : Optional.empty();
    }

    static {
        String cipherString = System.getProperty(SSL_CIPHERS_PROPERTY);
        ImmutableList<String> ciphers = null;
        if (cipherString != null) {
            ciphers = ImmutableList.copyOf(cipherString.split(","));
        }
        SSL_CIPHERS = ciphers;
    }
}

