/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator;

import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.service.coordinator.ClusterServiceSetManager;
import cdjd.com.dremio.service.coordinator.CoordinatorLostHandle;
import cdjd.com.dremio.service.coordinator.NodeStatusListener;
import cdjd.com.google.common.base.Joiner;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLeaderStatusListener
implements NodeStatusListener,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TaskLeaderStatusListener.class);
    private final Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider;
    private final String taskName;
    private final Object taskLeaderLock = new Object();
    private volatile CoordinationProtos.NodeEndpoint taskLeaderNode = null;
    private volatile boolean taskLeaderUp;
    private volatile boolean shutdown = false;
    private CoordinatorLostHandle leaderUnregisteredHandle;

    public TaskLeaderStatusListener(String taskName, Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider) {
        this(taskName, clusterServiceSetManagerProvider, false, null);
    }

    public TaskLeaderStatusListener(String taskName, Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider, boolean isLeader, CoordinatorLostHandle leaderUnregisteredHandle) {
        this.taskName = taskName;
        this.clusterServiceSetManagerProvider = clusterServiceSetManagerProvider;
        this.taskLeaderUp = isLeader;
        this.leaderUnregisteredHandle = leaderUnregisteredHandle;
        if (!this.taskLeaderUp && leaderUnregisteredHandle != null) {
            leaderUnregisteredHandle.handleMasterDown(this);
        }
    }

    public boolean isTaskLeaderUp() {
        return this.taskLeaderUp;
    }

    public void start() throws Exception {
        logger.info("Starting TaskLeaderStatusListener for: {}", (Object)this.taskName);
        ((ClusterServiceSetManager)this.clusterServiceSetManagerProvider.get()).getOrCreateServiceSet(this.taskName).addNodeStatusListener(this);
        this.nodesRegistered(new HashSet<CoordinationProtos.NodeEndpoint>(((ClusterServiceSetManager)this.clusterServiceSetManagerProvider.get()).getOrCreateServiceSet(this.taskName).getAvailableEndpoints()));
        logger.info("TaskLeaderStatusListener for: {} is up", (Object)this.taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        logger.info("Stopping TaskLeaderStatusListener for: {}", (Object)this.taskName);
        this.shutdown = true;
        Object object = this.taskLeaderLock;
        synchronized (object) {
            this.taskLeaderLock.notifyAll();
        }
        ((ClusterServiceSetManager)this.clusterServiceSetManagerProvider.get()).getOrCreateServiceSet(this.taskName).removeNodeStatusListener(this);
        logger.info("Stopped TaskLeaderStatusListener for: {}", (Object)this.taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodesUnregistered(Set<CoordinationProtos.NodeEndpoint> unregisteredNodes) {
        Object object = this.taskLeaderLock;
        synchronized (object) {
            if (this.taskLeaderNode == null) {
                logger.warn("Receiving unregistration notice for {}, but no TaskLeader for {} was registered", (Object)Joiner.on(",").join(unregisteredNodes.stream().map(input -> String.format("%s:%d", input.getAddress(), input.getFabricPort())).collect(Collectors.toList())), (Object)this.taskName);
                return;
            }
            if (unregisteredNodes.contains(this.taskLeaderNode)) {
                this.taskLeaderNode = null;
                this.taskLeaderUp = false;
                this.taskLeaderLock.notifyAll();
                if (this.leaderUnregisteredHandle != null) {
                    this.leaderUnregisteredHandle.handleMasterDown(this);
                }
            }
        }
    }

    public CoordinationProtos.NodeEndpoint getTaskLeaderNode() {
        return this.taskLeaderNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodesRegistered(Set<CoordinationProtos.NodeEndpoint> registeredNodes) {
        Iterator<CoordinationProtos.NodeEndpoint> iterator = registeredNodes.iterator();
        if (!iterator.hasNext()) {
            logger.warn("Received empty node registration for {}", (Object)this.taskName);
            return;
        }
        CoordinationProtos.NodeEndpoint endpoint = iterator.next();
        Object object = this.taskLeaderLock;
        synchronized (object) {
            if (this.taskLeaderNode != null && !this.taskLeaderNode.equals(endpoint)) {
                logger.info("Leader for task {} for node changed. Previous was {}:{}, new is {}:{}", this.taskName, this.taskLeaderNode.getAddress(), this.taskLeaderNode.getFabricPort(), endpoint.getAddress(), endpoint.getFabricPort());
            } else {
                logger.info("New Leader node for task {} {}:{} registered itself.", this.taskName, endpoint.getAddress(), endpoint.getFabricPort());
            }
            this.taskLeaderNode = endpoint;
            this.taskLeaderUp = true;
            this.taskLeaderLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTaskLeader() throws InterruptedException {
        long waitTimeInSecs = 0L;
        while (!this.shutdown && !this.isTaskLeaderUp()) {
            if (waitTimeInSecs % 60L == 0L) {
                logger.info("Waiting for leader for task {}", (Object)this.taskName);
            }
            waitTimeInSecs += 5L;
            Object object = this.taskLeaderLock;
            synchronized (object) {
                this.taskLeaderLock.wait(5000L);
            }
        }
    }
}

