/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator;

import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.service.coordinator.ClusterServiceSetManager;
import cdjd.com.dremio.service.coordinator.ElectionListener;
import cdjd.com.dremio.service.coordinator.ElectionRegistrationHandle;
import cdjd.com.dremio.service.coordinator.RegistrationHandle;
import cdjd.com.dremio.service.coordinator.ServiceSet;
import cdjd.com.dremio.service.coordinator.TaskLeaderChangeListener;
import cdjd.com.dremio.service.coordinator.TaskLeaderStatusListener;
import cdjd.com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLeaderElection
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TaskLeaderElection.class);
    private final Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider;
    private final TaskLeaderStatusListener taskLeaderStatusListener;
    private final String serviceName;
    private final AtomicReference<Long> leaseExpirationTime = new AtomicReference<Object>(null);
    private final ScheduledExecutorService executorService;
    private final Provider<CoordinationProtos.NodeEndpoint> currentEndPoint;
    private ElectionRegistrationHandle electionHandle;
    private final AtomicBoolean isTaskLeader = new AtomicBoolean(false);
    private volatile boolean isLatchClosed = false;
    private ServiceSet serviceSet;
    private volatile RegistrationHandle nodeEndpointRegistrationHandle;
    private Future leadershipReleaseFuture;
    private ConcurrentMap<TaskLeaderChangeListener, TaskLeaderChangeListener> listeners = new ConcurrentHashMap<TaskLeaderChangeListener, TaskLeaderChangeListener>();

    public TaskLeaderElection(String serviceName, Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider, Provider<CoordinationProtos.NodeEndpoint> currentEndPoint) {
        this(serviceName, clusterServiceSetManagerProvider, null, currentEndPoint, null);
    }

    public TaskLeaderElection(String serviceName, Provider<ClusterServiceSetManager> clusterServiceSetManagerProvider, Long leaseExpirationTime, Provider<CoordinationProtos.NodeEndpoint> currentEndPoint, ScheduledExecutorService executorService) {
        this.serviceName = serviceName;
        this.clusterServiceSetManagerProvider = clusterServiceSetManagerProvider;
        this.leaseExpirationTime.set(leaseExpirationTime);
        this.executorService = executorService;
        this.currentEndPoint = currentEndPoint;
        this.taskLeaderStatusListener = new TaskLeaderStatusListener(serviceName, clusterServiceSetManagerProvider);
    }

    public void start() throws Exception {
        this.serviceSet = ((ClusterServiceSetManager)this.clusterServiceSetManagerProvider.get()).getOrCreateServiceSet(this.serviceName);
        this.taskLeaderStatusListener.start();
        this.enterElections();
    }

    public void addListener(TaskLeaderChangeListener listener) {
        this.listeners.put(listener, listener);
    }

    public void removeListener(TaskLeaderChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void updateLeaseExpirationTime(Long newLeaseExpirationTime) {
        this.leaseExpirationTime.updateAndGet(operand -> newLeaseExpirationTime);
    }

    @VisibleForTesting
    public Collection<TaskLeaderChangeListener> getTaskLeaderChangeListeners() {
        return this.listeners.values();
    }

    private void enterElections() {
        logger.info("Starting TaskLeader Election Service for {}", (Object)this.serviceName);
        this.electionHandle = ((ClusterServiceSetManager)this.clusterServiceSetManagerProvider.get()).joinElection(this.serviceName, new ElectionListener(){

            @Override
            public void onElected() {
                if (TaskLeaderElection.this.isTaskLeader.compareAndSet(false, true)) {
                    logger.info("Electing Leader for {}", (Object)TaskLeaderElection.this.serviceName);
                    TaskLeaderElection.this.nodeEndpointRegistrationHandle = TaskLeaderElection.this.serviceSet.register((CoordinationProtos.NodeEndpoint)TaskLeaderElection.this.currentEndPoint.get());
                    TaskLeaderElection.this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipGained);
                    if (TaskLeaderElection.this.leaseExpirationTime.get() != null) {
                        TaskLeaderElection.this.leadershipReleaseFuture = TaskLeaderElection.this.executorService.schedule(new LeadershipReset(), (long)((Long)TaskLeaderElection.this.leaseExpirationTime.get()), TimeUnit.MILLISECONDS);
                    }
                }
            }

            @Override
            public void onCancelled() {
                if (TaskLeaderElection.this.isTaskLeader.compareAndSet(true, false)) {
                    logger.info("Rejecting Leader for {}", (Object)TaskLeaderElection.this.serviceName);
                    if (TaskLeaderElection.this.leadershipReleaseFuture != null) {
                        TaskLeaderElection.this.leadershipReleaseFuture.cancel(false);
                    }
                    TaskLeaderElection.this.nodeEndpointRegistrationHandle.close();
                    TaskLeaderElection.this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipLost);
                }
            }
        });
        this.isLatchClosed = false;
    }

    public CoordinationProtos.NodeEndpoint getTaskLeader() {
        try {
            this.taskLeaderStatusListener.waitForTaskLeader();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.taskLeaderStatusListener.getTaskLeaderNode();
    }

    public boolean isTaskLeader() {
        return this.isTaskLeader.get();
    }

    public Long getLeaseExpirationTime() {
        return this.leaseExpirationTime.get();
    }

    @VisibleForTesting
    public CoordinationProtos.NodeEndpoint getCurrentEndPoint() {
        return (CoordinationProtos.NodeEndpoint)this.currentEndPoint.get();
    }

    @Override
    public void close() throws Exception {
        if (this.isTaskLeader.compareAndSet(true, false)) {
            this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipLost);
        }
        this.listeners.clear();
        if (this.leadershipReleaseFuture != null) {
            this.leadershipReleaseFuture.cancel(true);
        }
        if (this.isLatchClosed) {
            AutoCloseables.close(this.taskLeaderStatusListener);
        } else {
            AutoCloseables.close(this.nodeEndpointRegistrationHandle, this.electionHandle, this.taskLeaderStatusListener);
        }
    }

    private class LeadershipReset
    implements Runnable {
        private LeadershipReset() {
        }

        @Override
        public void run() {
            if (TaskLeaderElection.this.isTaskLeader.compareAndSet(true, false) && TaskLeaderElection.this.electionHandle.instanceCount() > 1) {
                try {
                    logger.info("Trying to relinquish leadership for {}, as number of participants is {}", (Object)TaskLeaderElection.this.serviceName, (Object)TaskLeaderElection.this.electionHandle.instanceCount());
                    TaskLeaderElection.this.listeners.keySet().forEach(TaskLeaderChangeListener::onLeadershipRelinquished);
                    AutoCloseables.close(TaskLeaderElection.this.nodeEndpointRegistrationHandle, TaskLeaderElection.this.electionHandle);
                    TaskLeaderElection.this.isLatchClosed = true;
                    if (TaskLeaderElection.this.leadershipReleaseFuture != null) {
                        TaskLeaderElection.this.leadershipReleaseFuture.cancel(false);
                    }
                }
                catch (InterruptedException ie) {
                    logger.error("Current thread is interrupted. stopping elections for {} before leader reelections for {}", (Object)TaskLeaderElection.this.serviceName, (Object)ie);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    logger.error("Error while trying to close elections before leader reelections for {}", (Object)TaskLeaderElection.this.serviceName);
                }
                TaskLeaderElection.this.enterElections();
            } else {
                logger.info("Do not relinquish leadership as it is {} and number of election participants is {}", (Object)(TaskLeaderElection.this.isTaskLeader.get() ? "task leader" : "task follower"), (Object)TaskLeaderElection.this.electionHandle.instanceCount());
            }
        }
    }
}

