/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator;

import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.service.coordinator.AbstractServiceSet;
import cdjd.com.dremio.service.coordinator.ClusterCoordinator;
import cdjd.com.dremio.service.coordinator.DistributedSemaphore;
import cdjd.com.dremio.service.coordinator.ElectionListener;
import cdjd.com.dremio.service.coordinator.ElectionRegistrationHandle;
import cdjd.com.dremio.service.coordinator.RegistrationHandle;
import cdjd.com.dremio.service.coordinator.ServiceSet;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpClusterCoordinator
extends ClusterCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(NoOpClusterCoordinator.class);
    private static final NoOpServiceSet NO_OP_SERVICE_SET = new NoOpServiceSet();

    public NoOpClusterCoordinator() {
        logger.info("NoOp Cluster coordinator is up.");
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public ServiceSet getServiceSet(ClusterCoordinator.Role role) {
        return NO_OP_SERVICE_SET;
    }

    @Override
    public ServiceSet getOrCreateServiceSet(String serviceName) {
        return NO_OP_SERVICE_SET;
    }

    @Override
    public Iterable<String> getServiceNames() throws Exception {
        return Collections.emptySet();
    }

    @Override
    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        throw new UnsupportedOperationException("getSemaphore not implemented in NoOpClusterCoordinator");
    }

    @Override
    public ElectionRegistrationHandle joinElection(String name, ElectionListener listener) {
        throw new UnsupportedOperationException("joinElection not implemented in NoOpClusterCoordinator");
    }

    @Override
    public void close() throws Exception {
        logger.info("Stopped NoOp Cluster coordinator.");
    }

    private static final class NoOpServiceSet
    extends AbstractServiceSet
    implements AutoCloseable {
        private NoOpServiceSet() {
        }

        @Override
        public RegistrationHandle register(CoordinationProtos.NodeEndpoint endpoint) {
            return () -> {};
        }

        @Override
        public Collection<CoordinationProtos.NodeEndpoint> getAvailableEndpoints() {
            return Collections.emptySet();
        }

        @Override
        public void close() {
        }
    }
}

