/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.io;

import cdjd.com.dremio.io.file.Path;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.io.netty.buffer.Unpooled;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public interface AsyncByteReader
extends AutoCloseable {
    public static final CompletableFuture<Void> completedFuture = CompletableFuture.completedFuture(null);

    public CompletableFuture<Void> readFully(long var1, ByteBuf var3, int var4, int var5);

    default public CompletableFuture<Void> checkVersion(String version) {
        return completedFuture;
    }

    default public CompletableFuture<Void> versionedReadFully(String version, long offset, ByteBuf dst, int dstOffset, int len) {
        return CompletableFuture.allOf(this.checkVersion(version), this.readFully(offset, dst, dstOffset, len)).whenComplete((v, e) -> {
            if (e != null) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) {
                    throw new CompletionException(cause);
                }
                throw new CompletionException((Throwable)e);
            }
        });
    }

    default public CompletableFuture<byte[]> readFully(long offset, int len) {
        ByteBuf buf = Unpooled.directBuffer(len);
        CompletableFuture<Void> innerFuture = this.readFully(offset, buf, 0, len);
        return ((CompletableFuture)innerFuture.thenApply(v -> {
            byte[] bytes = new byte[len];
            buf.getBytes(0, bytes, 0, len);
            return bytes;
        })).whenComplete((a, b) -> buf.release());
    }

    @Override
    default public void close() throws Exception {
    }

    default public List<ReaderStat> getStats() {
        return Collections.emptyList();
    }

    public static interface FileKey {
        public List<String> getDatasetKey();

        public Path getPath();

        public String getVersion();

        public FileType getFileType();

        public static FileKey of(Path path, String version, FileType fileType) {
            return FileKey.of(path, version, fileType, null);
        }

        public static FileKey of(final Path path, final String version, final FileType fileType, final List<String> dataset) {
            Objects.requireNonNull(path, "path is required");
            Objects.requireNonNull(version, "version is required");
            Objects.requireNonNull(fileType, "file type is required");
            return new FileKey(){
                private final List<String> datasetKey;
                {
                    this.datasetKey = dataset != null ? ImmutableList.copyOf(dataset) : null;
                }

                @Override
                public Path getPath() {
                    return path;
                }

                @Override
                public String getVersion() {
                    return version;
                }

                @Override
                public FileType getFileType() {
                    return fileType;
                }

                @Override
                public List<String> getDatasetKey() {
                    return this.datasetKey;
                }
            };
        }

        public static enum FileType {
            PARQUET,
            ORC,
            OTHER;

        }
    }

    public static class ReaderStat {
        String name;
        double value;

        public ReaderStat(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double newValue) {
            this.value = newValue;
        }
    }
}

