/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.vector.accessor.sql;

import cdjd.com.google.common.collect.ImmutableList;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Objects;

public class TimePrintMillis
extends Time {
    private static final List<String> LEADING_ZEROES = ImmutableList.of("", "0", "00");
    private static final int DESIRED_MILLIS_LENGTH = 3;
    private final int millisOfSecond;

    public TimePrintMillis(long time) {
        this(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    public TimePrintMillis(LocalDateTime time) {
        super(time.getHour(), time.getMinute(), time.getSecond());
        this.millisOfSecond = time.get(ChronoField.MILLI_OF_SECOND);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TimePrintMillis && super.equals(obj)) {
            return this.millisOfSecond == ((TimePrintMillis)obj).millisOfSecond;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.millisOfSecond);
    }

    @Override
    public String toString() {
        StringBuilder time = new StringBuilder().append(super.toString());
        if (this.millisOfSecond > 0) {
            String millisString = Integer.toString(this.millisOfSecond);
            time.append(".");
            int millisLength = millisString.length();
            if (millisLength < 3) {
                time.append(LEADING_ZEROES.get(3 - millisLength));
            }
            time.append(millisString);
        }
        return time.toString();
    }
}

