/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.vector.accessor;

import cdjd.com.dremio.common.types.TypeProtos;
import cdjd.com.dremio.common.types.Types;
import cdjd.com.dremio.exec.vector.accessor.AbstractSqlAccessor;
import cdjd.com.google.common.base.Preconditions;
import cdjd.org.apache.arrow.vector.DateMilliVector;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.TimeZone;

public class DateMilliAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.DATE);
    private final TimeZone defaultTimeZone;
    private final DateMilliVector ac;

    public DateMilliAccessor(DateMilliVector vector, TimeZone defaultTZ) {
        this.ac = vector;
        this.defaultTimeZone = Preconditions.checkNotNull(defaultTZ, "Null TimeZone supplied.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getDate(index, this.defaultTimeZone);
    }

    @Override
    public Date getDate(int index, Calendar calendar) {
        Preconditions.checkNotNull(calendar, "Invalid calendar used when attempting to retrieve date.");
        return this.getDate(index, calendar.getTimeZone());
    }

    private Date getDate(int index, TimeZone tz) {
        if (this.ac.isNull(index)) {
            return null;
        }
        LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.ac.get(index)), tz.toZoneId());
        return new Date(date.getYear() - 1900, date.getMonthValue() - 1, date.getDayOfMonth());
    }
}

