/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.common.concurrent.NamedThreadFactory;
import cdjd.io.netty.channel.EventLoopGroup;
import cdjd.io.netty.channel.epoll.EpollEventLoopGroup;
import cdjd.io.netty.channel.epoll.EpollServerSocketChannel;
import cdjd.io.netty.channel.epoll.EpollSocketChannel;
import cdjd.io.netty.channel.nio.NioEventLoopGroup;
import cdjd.io.netty.channel.socket.ServerSocketChannel;
import cdjd.io.netty.channel.socket.SocketChannel;
import cdjd.io.netty.channel.socket.nio.NioServerSocketChannel;
import cdjd.io.netty.channel.socket.nio.NioSocketChannel;
import cdjd.io.netty.util.internal.SystemPropertyUtil;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportCheck {
    static final Logger logger = LoggerFactory.getLogger(TransportCheck.class);
    private static final String USE_LINUX_EPOLL = "dremio.exec.enable-epoll";
    public static final boolean SUPPORTS_EPOLL;
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER;

    private TransportCheck() {
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends SocketChannel> getClientSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static EventLoopGroup createEventLoopGroup(int nThreads, String prefix) {
        if (SUPPORTS_EPOLL) {
            return new EpollEventLoopGroup(nThreads, TransportCheck.newThreadFactory(prefix));
        }
        return new NioEventLoopGroup(nThreads, TransportCheck.newThreadFactory(prefix));
    }

    public static ThreadFactory newThreadFactory(String prefix) {
        NamedThreadFactory namedThreadFactory = new NamedThreadFactory(prefix);
        return runnable -> {
            Thread result = namedThreadFactory.newThread(runnable);
            result.setUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
            return result;
        };
    }

    static {
        String name = SystemPropertyUtil.get("os.name").toLowerCase(Locale.US).trim();
        SUPPORTS_EPOLL = name.startsWith("linux") && SystemPropertyUtil.getBoolean(USE_LINUX_EPOLL, false);
        UNCAUGHT_EXCEPTION_HANDLER = (thread, t) -> logger.error("Uncaught exception in thread {}", (Object)thread.getName(), (Object)t);
    }
}

