/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.common.exceptions.UserRemoteException;
import cdjd.com.dremio.common.util.DremioStringUtils;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.dremio.exec.rpc.UserRpcException;
import cdjd.com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcException
extends IOException {
    private static final long serialVersionUID = -5964230316010502319L;
    static final Logger logger = LoggerFactory.getLogger(RpcException.class);
    private final String status;
    private final String errorId;

    public RpcException() {
        this.status = null;
        this.errorId = null;
    }

    public RpcException(String message, Throwable cause) {
        this(message, null, null, cause);
    }

    public RpcException(String errMsg, String status, String errorId, Throwable cause) {
        super(RpcException.format(errMsg), cause);
        this.status = status;
        this.errorId = errorId;
    }

    public RpcException(String errMsg, String status, String errorId) {
        super(RpcException.format(errMsg));
        this.status = status;
        this.errorId = errorId;
    }

    private static String format(String message) {
        return DremioStringUtils.unescapeJava(message);
    }

    public RpcException(String message) {
        this(message, null, null);
    }

    public RpcException(Throwable cause) {
        super(cause);
        this.status = null;
        this.errorId = null;
    }

    public static RpcException mapException(Throwable t) {
        while (t instanceof ExecutionException) {
            t = t.getCause();
        }
        if (t instanceof RpcException) {
            return (RpcException)t;
        }
        return new RpcException(t);
    }

    public static RpcException mapException(String message, Throwable t) {
        while (t instanceof ExecutionException) {
            t = t.getCause();
        }
        return new RpcException(message, t);
    }

    public boolean isRemote() {
        return false;
    }

    public UserBitShared.DremioPBError getRemoteError() {
        throw new UnsupportedOperationException();
    }

    public static <T extends Throwable> void propagateIfPossible(@Nullable RpcException e, Class<T> clazz) throws T {
        Throwable t;
        Class<Throwable> exceptionClazz;
        if (e == null) {
            return;
        }
        Throwable cause = e.getCause();
        if (!(cause instanceof UserRemoteException)) {
            return;
        }
        UserRemoteException ure = (UserRemoteException)e.getCause();
        UserBitShared.DremioPBError remoteError = ure.getOrCreatePBError(false);
        UserBitShared.ExceptionWrapper ew = remoteError.getException();
        while (true) {
            try {
                exceptionClazz = Class.forName(ew.getExceptionClass()).asSubclass(Throwable.class);
            }
            catch (ClassNotFoundException cnfe) {
                logger.info("Cannot deserialize exception " + ew.getExceptionClass(), cnfe);
                return;
            }
            if (!UserRpcException.class.isAssignableFrom(exceptionClazz)) break;
            ew = ew.getCause();
        }
        try {
            Constructor<Throwable> constructor = exceptionClazz.getConstructor(String.class, Throwable.class);
            t = constructor.newInstance(ew.getMessage(), e);
        }
        catch (ReflectiveOperationException nsme) {
            try {
                Constructor<Throwable> constructor = exceptionClazz.getConstructor(String.class);
                t = constructor.newInstance(ew.getMessage()).initCause(e);
            }
            catch (ReflectiveOperationException rfe) {
                logger.info("Cannot deserialize exception " + ew.getExceptionClass(), rfe);
                return;
            }
        }
        Throwables.propagateIfPossible(t, clazz);
    }

    public String getStatus() {
        return this.status;
    }

    public String getErrorId() {
        return this.errorId;
    }
}

