/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.common.exceptions.UserException;
import cdjd.com.dremio.exec.proto.GeneralRPCProtos;
import cdjd.com.dremio.exec.rpc.AbstractHandshakeHandler;
import cdjd.com.dremio.exec.rpc.MessageDecoder;
import cdjd.com.dremio.exec.rpc.OutboundRpcMessage;
import cdjd.com.dremio.exec.rpc.RemoteConnection;
import cdjd.com.dremio.exec.rpc.Response;
import cdjd.com.dremio.exec.rpc.RpcBus;
import cdjd.com.dremio.exec.rpc.RpcConfig;
import cdjd.com.dremio.exec.rpc.RpcEncoder;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.exec.rpc.RpcExceptionHandler;
import cdjd.com.dremio.exec.rpc.RpcFuture;
import cdjd.com.dremio.exec.rpc.TransportCheck;
import cdjd.com.google.protobuf.Internal;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.com.google.protobuf.Parser;
import cdjd.io.netty.bootstrap.ServerBootstrap;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.io.netty.buffer.ByteBufAllocator;
import cdjd.io.netty.channel.Channel;
import cdjd.io.netty.channel.ChannelFutureListener;
import cdjd.io.netty.channel.ChannelHandler;
import cdjd.io.netty.channel.ChannelHandlerContext;
import cdjd.io.netty.channel.ChannelInitializer;
import cdjd.io.netty.channel.ChannelOption;
import cdjd.io.netty.channel.ChannelPipeline;
import cdjd.io.netty.channel.EventLoopGroup;
import cdjd.io.netty.channel.group.ChannelGroup;
import cdjd.io.netty.channel.group.DefaultChannelGroup;
import cdjd.io.netty.channel.socket.SocketChannel;
import cdjd.io.netty.handler.timeout.ReadTimeoutHandler;
import cdjd.io.netty.util.concurrent.GlobalEventExecutor;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

public abstract class BasicServer<T extends Internal.EnumLite, C extends RemoteConnection>
extends RpcBus<T, C> {
    protected static final String TIMEOUT_HANDLER = "timeout-handler";
    protected static final String MESSAGE_DECODER = "message-decoder";
    private final ServerBootstrap b;
    private final ChannelGroup allChannels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);

    public BasicServer(RpcConfig rpcMapping, ByteBufAllocator alloc, EventLoopGroup eventLoopGroup) {
        super(rpcMapping);
        this.b = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(TransportCheck.getServerSocketChannel())).option(ChannelOption.SO_BACKLOG, 1000)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)TimeUnit.SECONDS.toMillis(30L))).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, 131072)).option(ChannelOption.SO_SNDBUF, 131072)).group(eventLoopGroup).childOption(ChannelOption.ALLOCATOR, alloc).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                BasicServer.this.initChannel(ch);
            }

            @Override
            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                BasicServer.this.allChannels.add(ctx.channel());
                super.channelActive(ctx);
            }

            @Override
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                BasicServer.this.logger.warn("Failed to initialize a channel. Closing: {}", (Object)ctx.channel(), (Object)cause);
                ctx.close();
            }
        });
    }

    protected void initChannel(SocketChannel ch) throws SSLException {
        Object connection = this.initRemoteConnection(ch);
        ((RemoteConnection)connection).setChannelCloseHandler(this.newCloseListener(ch, connection));
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("protocol-encoder", (ChannelHandler)new RpcEncoder("s-" + this.rpcConfig.getName()));
        pipeline.addLast(MESSAGE_DECODER, (ChannelHandler)this.newDecoder(((RemoteConnection)connection).getAllocator()));
        pipeline.addLast("handshake-handler", this.newHandshakeHandler(connection));
        if (this.rpcConfig.hasTimeout()) {
            pipeline.addLast(TIMEOUT_HANDLER, (ChannelHandler)new LoggingReadTimeoutHandler(this, (RemoteConnection)connection, this.rpcConfig.getTimeout()));
        }
        pipeline.addLast("message-handler", (ChannelHandler)new RpcBus.InboundHandler((RpcBus)this, connection));
        pipeline.addLast("exception-handler", new RpcExceptionHandler(connection));
    }

    protected abstract MessageDecoder newDecoder(BufferAllocator var1);

    protected abstract ServerHandshakeHandler<?> newHandshakeHandler(C var1);

    @Override
    protected abstract Response handle(C var1, int var2, byte[] var3, ByteBuf var4) throws RpcException;

    @Override
    public <SEND extends MessageLite, RECEIVE extends MessageLite> RpcFuture<RECEIVE> send(C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        return super.send(connection, rpcType, protobufBody, clazz, dataBodies);
    }

    public int bind(int initialPort, boolean allowPortHunting) {
        int port = initialPort;
        while (true) {
            try {
                Channel channel = this.b.bind(port).sync().channel();
                this.allChannels.add(channel);
                port = ((InetSocketAddress)channel.localAddress()).getPort();
            }
            catch (Exception e) {
                if (e instanceof BindException && allowPortHunting) {
                    ++port;
                    continue;
                }
                throw UserException.resourceError(e).addContext("Server", this.rpcConfig.getName()).message("Could not bind to port %s.", port).build(this.logger);
            }
            break;
        }
        this.logger.info("[{}]: Server started on port {}.", (Object)this.rpcConfig.getName(), (Object)port);
        return port;
    }

    @Override
    public void close() throws IOException {
        try {
            this.allChannels.close().sync();
        }
        catch (InterruptedException e) {
            this.logger.warn("[{}]: Failure while shutting down.", (Object)this.rpcConfig.getName(), (Object)e);
            Thread.currentThread().interrupt();
        }
        this.logger.info("[{}]: Server shutdown.", (Object)this.rpcConfig.getName());
    }

    protected static abstract class ServerHandshakeHandler<T extends MessageLite>
    extends AbstractHandshakeHandler<T> {
        protected ServerHandshakeHandler(Internal.EnumLite handshakeType, Parser<T> parser) {
            super(handshakeType, parser);
        }

        @Override
        protected void consumeHandshake(ChannelHandlerContext ctx, T inbound) throws Exception {
            OutboundRpcMessage msg = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, this.handshakeType, this.coordinationId, this.getHandshakeResponse(inbound), new ByteBuf[0]);
            ctx.writeAndFlush(msg).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        }

        public abstract MessageLite getHandshakeResponse(T var1) throws Exception;
    }

    private class LoggingReadTimeoutHandler
    extends ReadTimeoutHandler {
        private final C connection;
        private final int timeoutSeconds;
        final /* synthetic */ BasicServer this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private LoggingReadTimeoutHandler(C connection, int timeoutSeconds) {
            this.this$0 = (BasicServer)n;
            super(timeoutSeconds);
            this.connection = connection;
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        protected void readTimedOut(ChannelHandlerContext ctx) throws Exception {
            this.this$0.logger.info("RPC connection {} timed out.  Timeout was set to {} seconds. Closing connection.", (Object)((RemoteConnection)this.connection).getName(), (Object)this.timeoutSeconds);
            super.readTimedOut(ctx);
        }
    }
}

