/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.exec.proto.GeneralRPCProtos;
import cdjd.com.dremio.exec.rpc.AbstractClient;
import cdjd.com.dremio.exec.rpc.AbstractHandshakeHandler;
import cdjd.com.dremio.exec.rpc.Acks;
import cdjd.com.dremio.exec.rpc.BasicClient;
import cdjd.com.dremio.exec.rpc.MessageDecoder;
import cdjd.com.dremio.exec.rpc.OutboundRpcMessage;
import cdjd.com.dremio.exec.rpc.RemoteConnection;
import cdjd.com.dremio.exec.rpc.RpcBus;
import cdjd.com.dremio.exec.rpc.RpcConfig;
import cdjd.com.dremio.exec.rpc.RpcConnectionHandler;
import cdjd.com.dremio.exec.rpc.RpcEncoder;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.exec.rpc.RpcExceptionHandler;
import cdjd.com.dremio.exec.rpc.RpcFuture;
import cdjd.com.dremio.exec.rpc.RpcOutcome;
import cdjd.com.dremio.exec.rpc.RpcOutcomeListener;
import cdjd.com.dremio.exec.rpc.TransportCheck;
import cdjd.com.dremio.ssl.SSLEngineFactory;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.protobuf.Internal;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.com.google.protobuf.Parser;
import cdjd.io.netty.bootstrap.Bootstrap;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.io.netty.buffer.ByteBufAllocator;
import cdjd.io.netty.channel.ChannelFuture;
import cdjd.io.netty.channel.ChannelFutureListener;
import cdjd.io.netty.channel.ChannelHandler;
import cdjd.io.netty.channel.ChannelHandlerContext;
import cdjd.io.netty.channel.ChannelInboundHandlerAdapter;
import cdjd.io.netty.channel.ChannelInitializer;
import cdjd.io.netty.channel.ChannelOption;
import cdjd.io.netty.channel.ChannelPipeline;
import cdjd.io.netty.channel.EventLoopGroup;
import cdjd.io.netty.channel.socket.SocketChannel;
import cdjd.io.netty.handler.ssl.SslHandler;
import cdjd.io.netty.handler.timeout.IdleState;
import cdjd.io.netty.handler.timeout.IdleStateEvent;
import cdjd.io.netty.handler.timeout.IdleStateHandler;
import cdjd.io.netty.util.concurrent.GenericFutureListener;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicClient<T extends Internal.EnumLite, R extends RemoteConnection, HS extends MessageLite, HR extends MessageLite>
extends AbstractClient<T, R, HS> {
    private static final Logger logger = LoggerFactory.getLogger(BasicClient.class);
    protected static final String PROTOCOL_DECODER = "protocol-decoder";
    protected static final String HANDSHAKE_REQUESTER = "handshake-requester";
    protected static final String SSL_CLIENT_HANDLER = "ssl-client-handler";
    protected static final String IDLE_STATE_HANDLER = "idle-state-handler";
    private static final OutboundRpcMessage PING_MESSAGE = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.PING, 0, 0, (MessageLite)Acks.OK, new ByteBuf[0]);
    private static final double PERCENT_TIMEOUT_BEFORE_SENDING_PING = 0.5;
    private final Class<HR> responseClass;
    private final T handshakeType;
    private final Parser<HR> handshakeParser;
    private final Optional<SSLEngineFactory> engineFactory;
    private final Bootstrap b;
    protected volatile R connection;

    public BasicClient(RpcConfig rpcMapping, ByteBufAllocator alloc, EventLoopGroup eventLoopGroup, T handshakeType, Class<HR> responseClass, Parser<HR> handshakeParser, Optional<SSLEngineFactory> engineFactory) throws RpcException {
        super(rpcMapping);
        this.responseClass = responseClass;
        this.handshakeType = handshakeType;
        this.handshakeParser = handshakeParser;
        this.engineFactory = engineFactory;
        final long timeoutInMillis = rpcMapping.hasTimeout() ? (long)((double)rpcMapping.getTimeout() * 1000.0 * 0.5) : -1L;
        this.b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(TransportCheck.getClientSocketChannel())).option(ChannelOption.ALLOCATOR, alloc)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, 131072)).option(ChannelOption.SO_SNDBUF, 131072)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                BasicClient.this.connection = BasicClient.this.initRemoteConnection(ch);
                ch.closeFuture().addListener(BasicClient.this.newCloseListener(ch, BasicClient.this.connection));
                ChannelPipeline pipe = ch.pipeline();
                pipe.addLast("protocol-encoder", (ChannelHandler)new RpcEncoder("c-" + BasicClient.this.rpcConfig.getName()));
                pipe.addLast(BasicClient.PROTOCOL_DECODER, (ChannelHandler)BasicClient.this.newDecoder(((RemoteConnection)BasicClient.this.connection).getAllocator()));
                pipe.addLast("handshake-handler", (ChannelHandler)new ClientHandshakeHandler());
                if (timeoutInMillis != -1L) {
                    pipe.addLast(BasicClient.IDLE_STATE_HANDLER, (ChannelHandler)new IdlePingHandler(timeoutInMillis));
                }
                pipe.addLast("message-handler", (ChannelHandler)new RpcBus.InboundHandler((RpcBus)BasicClient.this, BasicClient.this.connection));
                pipe.addLast("exception-handler", new RpcExceptionHandler(BasicClient.this.connection));
            }
        });
    }

    public abstract MessageDecoder newDecoder(BufferAllocator var1);

    protected abstract void validateHandshake(HR var1) throws RpcException;

    protected abstract void finalizeConnection(HR var1, R var2);

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        super.send(listener, this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> RpcFuture<RECEIVE> send(T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        return super.send(this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    @Override
    protected void connectAsClient(RpcConnectionHandler<R> connectionHandler, HS handshakeValue, String host, int port) {
        ConnectionMultiListener cml = new ConnectionMultiListener(this, connectionHandler, handshakeValue, host, port);
        this.b.connect(host, port).addListener(cml.establishmentListener);
    }

    public boolean isActive() {
        return this.connection != null && ((RemoteConnection)this.connection).getChannel() != null && ((RemoteConnection)this.connection).getChannel().isActive();
    }

    public void setAutoRead(boolean enableAutoRead) {
        ((RemoteConnection)this.connection).setAutoRead(enableAutoRead);
    }

    @Override
    public void close() {
        logger.debug("Closing client");
        try {
            if (this.connection != null) {
                ((RemoteConnection)this.connection).getChannel().close().sync();
            }
        }
        catch (InterruptedException e) {
            logger.warn("Failure while shutting {}", (Object)this.getClass().getName(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private class IdlePingHandler
    extends IdleStateHandler {
        private final ChannelFutureListener pingFailedListener;

        IdlePingHandler(long idleWaitInMillis) {
            super(0L, idleWaitInMillis, 0L, TimeUnit.MILLISECONDS);
            this.pingFailedListener = future -> {
                if (!future.isSuccess()) {
                    logger.error("Unable to maintain connection {}. Closing connection.", (Object)((RemoteConnection)BasicClient.this.connection).getName());
                    ((RemoteConnection)BasicClient.this.connection).close();
                }
            };
        }

        @Override
        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.WRITER_IDLE) {
                ctx.writeAndFlush(PING_MESSAGE).addListener(this.pingFailedListener);
            }
        }
    }

    private class ClientHandshakeHandler
    extends AbstractHandshakeHandler<HR> {
        ClientHandshakeHandler() {
            super(BasicClient.this.handshakeType, BasicClient.this.handshakeParser);
        }

        @Override
        protected final void consumeHandshake(ChannelHandlerContext ctx, HR msg) throws Exception {
            RpcOutcome response = ((RemoteConnection)BasicClient.this.connection).getAndRemoveRpcOutcome(this.handshakeType.getNumber(), this.coordinationId, BasicClient.this.responseClass);
            response.set(msg, null);
        }
    }

    private class ConnectionMultiListener {
        private final cdjd.com.dremio.exec.rpc.BasicClient$ConnectionMultiListener.ConnectionEstablishmentListener establishmentListener = new ConnectionEstablishmentListener();
        private final cdjd.com.dremio.exec.rpc.BasicClient$ConnectionMultiListener.HandshakeSendListener handshakeSendListener = new HandshakeSendListener();
        private final RpcConnectionHandler<R> connectionHandler;
        private final HS handshakeValue;
        private final String hostName;
        private final int port;
        final /* synthetic */ BasicClient this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        ConnectionMultiListener(RpcConnectionHandler<R> connectionHandler, HS handshakeValue, String hostName, int port) {
            this.this$0 = (BasicClient)n;
            this.hostName = hostName;
            this.port = port;
            assert (connectionHandler != null);
            assert (handshakeValue != null);
            this.connectionHandler = connectionHandler;
            this.handshakeValue = handshakeValue;
        }

        void sendHandshake() {
            Preconditions.checkState(this.this$0.connection != null, "connection is not yet initialized");
            this.this$0.send(this.handshakeSendListener, this.this$0.connection, this.this$0.handshakeType, this.handshakeValue, this.this$0.responseClass, true, new ByteBuf[0]);
        }

        private class HandshakeSendListener
        implements RpcOutcomeListener<HR> {
            private HandshakeSendListener() {
            }

            @Override
            public void failed(RpcException ex) {
                logger.debug("Failure while initiating handshake", ex);
                ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
            }

            @Override
            public void success(HR value, ByteBuf buffer) {
                logger.debug("Handshake received on {}", ConnectionMultiListener.this.this$0.connection);
                try {
                    ConnectionMultiListener.this.this$0.validateHandshake(value);
                    ConnectionMultiListener.this.this$0.finalizeConnection(value, ConnectionMultiListener.this.this$0.connection);
                    ConnectionMultiListener.this.connectionHandler.connectionSucceeded(ConnectionMultiListener.this.this$0.connection);
                    logger.trace("Handshake completed successfully on {}", ConnectionMultiListener.this.this$0.connection);
                }
                catch (RpcException ex) {
                    logger.debug("Failure while validating handshake", ex);
                    ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_VALIDATION, ex);
                }
            }

            @Override
            public void interrupted(InterruptedException ex) {
                logger.warn("Interrupted while waiting for handshake response", ex);
                ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
            }
        }

        private class HandshakeRequester
        extends ChannelInboundHandlerAdapter {
            private HandshakeRequester() {
            }

            private void sendHandshakeAndRemoveSelf(ChannelHandlerContext ctx) {
                ConnectionMultiListener.this.sendHandshake();
                ctx.channel().pipeline().remove(this);
            }

            @Override
            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                if (ctx.channel().isActive()) {
                    this.sendHandshakeAndRemoveSelf(ctx);
                }
            }

            @Override
            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                this.sendHandshakeAndRemoveSelf(ctx);
                super.channelActive(ctx);
            }
        }

        private class ConnectionEstablishmentListener
        implements GenericFutureListener<ChannelFuture> {
            private ConnectionEstablishmentListener() {
            }

            @Override
            public void operationComplete(ChannelFuture connectionFuture) throws Exception {
                boolean isInterrupted = false;
                long remainingWaitTimeMillis = 120000L;
                long startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        connectionFuture.get(remainingWaitTimeMillis, TimeUnit.MILLISECONDS);
                        logger.trace("Connection establishment to '{}' completed with state '{}'", (Object)connectionFuture.channel(), (Object)connectionFuture.isSuccess());
                        if (!connectionFuture.isSuccess()) {
                            ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, new RpcException("General connection failure.", connectionFuture.cause()));
                            break;
                        }
                        this.addNegotiator(connectionFuture);
                    }
                    catch (InterruptedException ie) {
                        long now = System.currentTimeMillis();
                        startTime = now;
                        isInterrupted = true;
                        if ((remainingWaitTimeMillis -= now - startTime) >= 1L) continue;
                        ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ie);
                    }
                    catch (Exception ex) {
                        logger.error("Failed to establish connection", ex);
                        ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ex);
                    }
                    break;
                }
                if (isInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }

            void addNegotiator(ChannelFuture connectionFuture) throws Exception {
                if (!ConnectionMultiListener.this.this$0.rpcConfig.getSSLConfig().isPresent()) {
                    logger.trace("Adding handshake negotiator on '{}'", (Object)connectionFuture.channel());
                    this.addHandshakeRequester(connectionFuture);
                    return;
                }
                assert (ConnectionMultiListener.this.this$0.engineFactory.isPresent());
                SSLEngine clientEngine = ((SSLEngineFactory)ConnectionMultiListener.this.this$0.engineFactory.get()).newClientEngine(connectionFuture.channel().alloc(), ConnectionMultiListener.this.hostName, ConnectionMultiListener.this.port);
                SslHandler sslHandler = new SslHandler(clientEngine);
                sslHandler.handshakeFuture().addListener(future -> {
                    logger.debug("SSL client state '{}' on connection '{}'", (Object)future.isSuccess(), (Object)connectionFuture.channel());
                    if (future.isSuccess()) {
                        logger.trace("Adding handshake negotiator on '{}', after SSL succeeded", (Object)connectionFuture.channel());
                        this.addHandshakeRequester(connectionFuture);
                    } else {
                        ConnectionMultiListener.this.connectionHandler.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, new RpcException("SSL negotiation failed", future.cause()));
                    }
                });
                logger.trace("Adding SSL negotiator on '{}'", (Object)connectionFuture.channel());
                connectionFuture.channel().pipeline().addFirst(BasicClient.SSL_CLIENT_HANDLER, (ChannelHandler)sslHandler);
            }

            void addHandshakeRequester(ChannelFuture connectionFuture) {
                connectionFuture.channel().pipeline().addBefore("handshake-handler", BasicClient.HANDSHAKE_REQUESTER, new HandshakeRequester());
            }
        }
    }
}

