/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.record;

import cdjd.com.dremio.exec.record.BatchSchema;
import cdjd.com.dremio.exec.record.VectorAccessible;
import cdjd.com.dremio.exec.record.VectorContainer;
import cdjd.com.dremio.exec.record.VectorWrapper;
import cdjd.com.dremio.exec.record.selection.SelectionVector2;
import cdjd.com.google.common.collect.Lists;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordBatchData
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(RecordBatchData.class);
    private int recordCount;
    private SelectionVector2 sv2;
    VectorContainer container = new VectorContainer();

    public RecordBatchData(VectorAccessible batch, BufferAllocator allocator) {
        this(batch, allocator, true);
    }

    public RecordBatchData(VectorAccessible batch, BufferAllocator allocator, boolean applySVMode) {
        this.recordCount = batch.getRecordCount();
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        this.sv2 = applySVMode && batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE ? batch.getSelectionVector2().clone() : null;
        for (VectorWrapper v : batch) {
            if (v.isHyper()) {
                throw new UnsupportedOperationException("Record batch data can't be created based on a hyper batch.");
            }
            TransferPair tp = v.getValueVector().getTransferPair(allocator);
            tp.transfer();
            vectors.add(tp.getTo());
        }
        this.container.addCollection(vectors);
        this.container.setRecordCount(this.recordCount);
        this.container.buildSchema(applySVMode ? batch.getSchema().getSelectionVectorMode() : BatchSchema.SelectionVectorMode.NONE);
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public List<ValueVector> getVectors() {
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        for (VectorWrapper<?> w : this.container) {
            vectors.add((ValueVector)w.getValueVector());
        }
        return vectors;
    }

    public void setSv2(SelectionVector2 sv2) {
        this.sv2 = sv2;
        this.recordCount = sv2.getCount();
        this.container.buildSchema(BatchSchema.SelectionVectorMode.TWO_BYTE);
    }

    public SelectionVector2 getSv2() {
        return this.sv2;
    }

    public VectorContainer getContainer() {
        return this.container;
    }

    @Deprecated
    public void clear() {
        this.close();
    }

    @Override
    public void close() {
        if (this.sv2 != null) {
            this.sv2.clear();
        }
        this.container.clear();
    }

    public BatchSchema getSchema() {
        return this.container.getSchema();
    }
}

