/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.record;

import cdjd.com.dremio.common.expression.BasePath;
import cdjd.com.dremio.exec.record.TypedFieldId;
import cdjd.com.dremio.exec.record.VectorWrapper;
import cdjd.com.google.common.base.Preconditions;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.complex.AbstractStructVector;
import cdjd.org.apache.arrow.vector.complex.FieldIdUtil2;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.util.CallBack;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperVectorWrapper<T extends ValueVector>
implements VectorWrapper<T> {
    static final Logger logger = LoggerFactory.getLogger(HyperVectorWrapper.class);
    private List<T> vectors = new ArrayList<T>();
    private T[] cachedVectors;
    private boolean cachedVectorsValid;
    private Field field;
    private final boolean releasable;

    public HyperVectorWrapper(Field field, T[] v) {
        this(field, (ValueVector[])v, true);
    }

    public HyperVectorWrapper(Field f, T[] v, boolean releasable) {
        this.field = f;
        this.vectors.addAll(Arrays.asList(v));
        this.cachedVectors = v;
        this.releasable = releasable;
        this.cachedVectorsValid = true;
    }

    @Override
    public Class<T> getVectorClass() {
        return this.cachedVectors.getClass().getComponentType();
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public T getValueVector() {
        throw new IllegalStateException("Tried to retrieve single vector on a hyper vector.");
    }

    @Override
    public T[] getValueVectors() {
        if (!this.cachedVectorsValid) {
            this.cachedVectors = (ValueVector[])this.vectors.toArray(this.cachedVectors);
            this.cachedVectorsValid = true;
        }
        return this.cachedVectors;
    }

    @Override
    public boolean isHyper() {
        return true;
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        if (!this.releasable) {
            return;
        }
        for (ValueVector x : this.vectors) {
            x.clear();
        }
    }

    @Override
    public VectorWrapper<?> getChildWrapper(int[] ids) {
        if (ids.length == 1) {
            return this;
        }
        ValueVector[] vectors = new ValueVector[this.vectors.size()];
        int index = 0;
        Iterator<T> iterator = this.vectors.iterator();
        while (iterator.hasNext()) {
            ValueVector v;
            ValueVector vector = v = (ValueVector)iterator.next();
            for (int i = 1; i < ids.length; ++i) {
                AbstractStructVector mapLike = (AbstractStructVector)AbstractStructVector.class.cast(vector);
                if (mapLike == null) {
                    return null;
                }
                vector = mapLike.getChildByOrdinal(ids[i]);
            }
            vectors[index] = vector;
            ++index;
        }
        return new HyperVectorWrapper(vectors[0].getField(), vectors);
    }

    @Override
    public TypedFieldId getFieldIdIfMatches(int id, BasePath expectedPath) {
        return FieldIdUtil2.getFieldId(this.field, id, expectedPath, true);
    }

    @Override
    public VectorWrapper<T> cloneAndTransfer(BufferAllocator allocator, CallBack callback) {
        if (this.vectors.size() == 0) {
            return new HyperVectorWrapper(this.field, (ValueVector[])this.vectors.toArray(), false);
        }
        ValueVector[] newVectors = (ValueVector[])Array.newInstance(((ValueVector)this.vectors.get(0)).getClass(), this.vectors.size());
        for (int i = 0; i < this.vectors.size(); ++i) {
            newVectors[i] = ((ValueVector)this.vectors.get(i)).getTransferPair(((ValueVector)this.vectors.get(i)).getField().getName(), allocator, callback).getTo();
        }
        return new HyperVectorWrapper(this.field, (ValueVector[])this.vectors.toArray(), false);
    }

    public static <T extends ValueVector> HyperVectorWrapper<T> create(Field f, T[] v, boolean releasable) {
        return new HyperVectorWrapper(f, v, releasable);
    }

    public void addVector(ValueVector v) {
        Preconditions.checkArgument(v.getClass() == this.getVectorClass(), "Cannot add vector type %s to hypervector type %s for field %s", v.getClass(), this.getVectorClass(), (Object)v.getField());
        this.vectors.add(v);
        this.cachedVectorsValid = false;
    }

    public void addVectors(ValueVector[] vv) {
        this.vectors.addAll(Arrays.asList(vv));
        this.cachedVectorsValid = false;
    }

    @Override
    public void transfer(VectorWrapper<?> destination) {
        Preconditions.checkArgument(destination instanceof HyperVectorWrapper);
        Preconditions.checkArgument(this.getField().getType().equals(destination.getField().getType()));
        Preconditions.checkArgument(this.vectors.size() == ((HyperVectorWrapper)destination).vectors.size());
        List<T> destionationVectors = ((HyperVectorWrapper)destination).vectors;
        for (int i = 0; i < this.vectors.size(); ++i) {
            ((ValueVector)this.vectors.get(i)).makeTransferPair((ValueVector)destionationVectors.get(i)).transfer();
        }
    }
}

