/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.client;

import cdjd.com.dremio.common.Version;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.dremio.exec.proto.UserProtos;
import cdjd.com.dremio.sabot.rpc.user.UserRpcUtils;
import cdjd.com.google.common.collect.ImmutableMap;
import cdjd.com.google.common.collect.ImmutableSet;
import cdjd.com.google.common.collect.Maps;
import cdjd.com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public enum ServerMethod {
    RUN_QUERY(UserProtos.RpcType.RUN_QUERY, Constants.access$000(), Constants.access$100()),
    PLAN_QUERY(UserProtos.RpcType.QUERY_PLAN_FRAGMENTS, Constants.access$000(), Constants.access$100()),
    CANCEL_QUERY(UserProtos.RpcType.CANCEL_QUERY, Constants.access$000(), Constants.access$100()),
    RESUME_PAUSED_QUERY(UserProtos.RpcType.RESUME_PAUSED_QUERY, Constants.access$000(), Constants.access$100()),
    PREPARED_STATEMENT(UserProtos.RpcType.CREATE_PREPARED_STATEMENT, Constants.access$000(), Constants.access$200()),
    GET_CATALOGS(UserProtos.RpcType.GET_CATALOGS, Constants.access$000(), Constants.access$200()),
    GET_SCHEMAS(UserProtos.RpcType.GET_SCHEMAS, Constants.access$000(), Constants.access$200()),
    GET_TABLES(UserProtos.RpcType.GET_TABLES, Constants.access$000(), Constants.access$200()),
    GET_COLUMNS(UserProtos.RpcType.GET_COLUMNS, Constants.access$000(), Constants.access$200()),
    GET_SERVER_META(UserProtos.RpcType.GET_SERVER_META, Constants.access$300(), Constants.access$400());

    private static final Map<UserProtos.RpcType, ServerMethod> REVERSE_MAPPING;
    private final UserProtos.RpcType rpcType;
    private final Version minVersion;
    private final Version minDrillVersion;

    private ServerMethod(UserProtos.RpcType rpcType, Version minVersion, Version minDrillVersion) {
        this.rpcType = rpcType;
        this.minVersion = minVersion;
        this.minDrillVersion = minDrillVersion;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public Version getMinDrillVersion() {
        return this.minDrillVersion;
    }

    static final Set<ServerMethod> getSupportedMethods(Iterable<UserProtos.RpcType> supportedMethods, UserBitShared.RpcEndpointInfos serverInfos) {
        Version serverVersion;
        boolean isDremio;
        boolean supportedMethodsEmpty = true;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (UserProtos.RpcType supportedMethod : supportedMethods) {
            supportedMethodsEmpty = false;
            ServerMethod method = REVERSE_MAPPING.get(supportedMethod);
            if (method == null) continue;
            builder.add((Object)method);
        }
        if (!supportedMethodsEmpty) {
            return Sets.immutableEnumSet(builder.build());
        }
        if (serverInfos == null) {
            isDremio = false;
            serverVersion = Constants.DRILL_0_0_0;
        } else {
            String serverName = serverInfos.getName().toLowerCase(Locale.ROOT);
            isDremio = serverName.contains("dremio");
            serverVersion = UserRpcUtils.getVersion(serverInfos);
        }
        for (ServerMethod capability : ServerMethod.values()) {
            Version minVersion;
            Version version = minVersion = isDremio ? capability.getMinVersion() : capability.getMinDrillVersion();
            if (serverVersion.compareTo(minVersion) < 0) continue;
            builder.add((Object)capability);
        }
        return Sets.immutableEnumSet(builder.build());
    }

    static {
        ImmutableMap.Builder<UserProtos.RpcType, ServerMethod> builder = ImmutableMap.builder();
        for (ServerMethod method : ServerMethod.values()) {
            builder.put(method.rpcType, method);
        }
        REVERSE_MAPPING = Maps.immutableEnumMap(builder.build());
    }

    private static class Constants {
        private static final Version DREMIO_0_0_0 = new Version("0.0.0", 0, 0, 0, 0, "");
        private static final Version DREMIO_0_9_3 = new Version("0.9.3", 0, 9, 3, 0, "");
        private static final Version DRILL_0_0_0 = new Version("0.0.0", 0, 0, 0, 0, "");
        private static final Version DRILL_1_8_0 = new Version("1.8.0", 1, 8, 0, 0, "");
        private static final Version DRILL_1_10_0 = new Version("1.10.0", 1, 8, 0, 0, "");

        private Constants() {
        }

        static /* synthetic */ Version access$000() {
            return DREMIO_0_0_0;
        }

        static /* synthetic */ Version access$200() {
            return DRILL_1_8_0;
        }

        static /* synthetic */ Version access$300() {
            return DREMIO_0_9_3;
        }

        static /* synthetic */ Version access$400() {
            return DRILL_1_10_0;
        }
    }
}

