/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.utils.protos;

import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.io.protostuff.ByteString;
import cdjd.io.protostuff.Output;
import cdjd.io.protostuff.Schema;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class BlackListOutput
implements Output {
    private static final int[] EmptyArray = new int[0];
    private final Output delegate;
    private final Map<String, int[]> schemaNameToBlackList;
    @VisibleForTesting
    int[] currentBlackList;

    @VisibleForTesting
    BlackListOutput(Output delegate, Map<String, int[]> schemaNameToBlackList, int[] currentBlackList) {
        this.delegate = delegate;
        this.schemaNameToBlackList = schemaNameToBlackList;
        this.currentBlackList = currentBlackList;
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeInt32(fieldNumber, value, repeated);
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeUInt32(fieldNumber, value, repeated);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeSInt32(fieldNumber, value, repeated);
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeFixed32(fieldNumber, value, repeated);
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeSFixed32(fieldNumber, value, repeated);
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeInt64(fieldNumber, value, repeated);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeUInt64(fieldNumber, value, repeated);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeSInt64(fieldNumber, value, repeated);
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeFixed64(fieldNumber, value, repeated);
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeSFixed64(fieldNumber, value, repeated);
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeFloat(fieldNumber, value, repeated);
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeDouble(fieldNumber, value, repeated);
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeBool(fieldNumber, value, repeated);
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeEnum(fieldNumber, value, repeated);
    }

    public void writeString(int fieldNumber, String value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeString(fieldNumber, value, repeated);
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeBytes(fieldNumber, value, repeated);
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeByteArray(fieldNumber, value, repeated);
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeByteRange(utf8String, fieldNumber, value, offset, length, repeated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        int[] parentBlackList = this.currentBlackList;
        try {
            String messageFullName = schema.messageFullName();
            this.currentBlackList = this.schemaNameToBlackList.getOrDefault(messageFullName, EmptyArray);
            this.writeString(fieldNumber * -1, messageFullName, repeated);
            schema.writeTo((Output)this, value);
            this.writeString(fieldNumber * -1, schema.messageName(), repeated);
        }
        finally {
            this.currentBlackList = parentBlackList;
        }
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        if (this.isBlackListed(fieldNumber)) {
            return;
        }
        this.delegate.writeBytes(fieldNumber, value, repeated);
    }

    private boolean isBlackListed(int fieldNumber) {
        for (int i = 0; i < this.currentBlackList.length; ++i) {
            if (this.currentBlackList[i] != fieldNumber) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        Map<String, int[]> blackListed = new HashMap<String, int[]>();

        public Builder blacklist(Schema<?> schema, String ... fields) {
            int[] blackListFieldsNumbers = new int[fields.length];
            if (this.blackListed.containsKey(schema.messageFullName())) {
                throw new RuntimeException(schema.messageFullName());
            }
            this.blackListed.put(schema.messageFullName(), blackListFieldsNumbers);
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                int fieldNumber = schema.getFieldNumber(field);
                if (fieldNumber == 0) {
                    throw new RuntimeException(schema.messageFullName() + ":" + field);
                }
                blackListFieldsNumbers[i] = fieldNumber;
            }
            return this;
        }

        public Function<Output, Output> build(Schema<?> startingSchema) {
            return output -> new BlackListOutput((Output)output, this.blackListed, this.blackListed.getOrDefault(startingSchema.messageFullName(), EmptyArray));
        }
    }
}

