/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.utils;

import cdjd.com.dremio.common.exceptions.UserException;
import cdjd.com.fasterxml.jackson.core.JsonEncoding;
import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.com.fasterxml.jackson.core.JsonParser;
import cdjd.io.protostuff.GraphIOUtil;
import cdjd.io.protostuff.JsonIOUtils;
import cdjd.io.protostuff.Message;
import cdjd.io.protostuff.Schema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtostuffUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProtostuffUtil.class);

    private ProtostuffUtil() {
    }

    public static <T extends Message<T>> T copy(T t) {
        try {
            Schema schema = t.cachedSchema();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GraphIOUtil.writeDelimitedTo((DataOutput)new DataOutputStream(out), t, (Schema)schema);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            Message newMessage = (Message)schema.newMessage();
            GraphIOUtil.mergeDelimitedFrom((InputStream)in, (Object)newMessage, (Schema)schema);
            return (T)newMessage;
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).message("Failure decoding object, please ensure that you ran dremio-admin upgrade on Dremio.", new Object[0]).build(logger);
        }
    }

    public static <T extends Message<T>> T merge(T to, T from) throws IOException {
        Schema schema = from.cachedSchema();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GraphIOUtil.writeDelimitedTo((DataOutput)new DataOutputStream(out), from, (Schema)schema);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        T cloneTo = ProtostuffUtil.copy(to);
        GraphIOUtil.mergeDelimitedFrom((InputStream)in, cloneTo, (Schema)schema);
        return cloneTo;
    }

    public static <T> void fromJSON(byte[] data, T message, Schema<T> schema, boolean numeric) throws IOException {
        try (JsonParser parser = JsonIOUtils.newJsonParser(null, data, 0, data.length).enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);){
            JsonIOUtils.mergeFrom(parser, message, schema, numeric);
        }
    }

    public static <T> T fromJSON(String data, Schema<T> schema, boolean numeric) throws IOException {
        Object message = schema.newMessage();
        ProtostuffUtil.fromJSON(data.getBytes(StandardCharsets.UTF_8), message, schema, numeric);
        return (T)message;
    }

    public static <T> void toJSON(OutputStream out, T message, Schema<T> schema, boolean numeric) throws IOException {
        try (JsonGenerator jsonGenerator = JsonIOUtils.DEFAULT_JSON_FACTORY.createGenerator(out, JsonEncoding.UTF8).disable(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS);){
            JsonIOUtils.writeTo(jsonGenerator, message, schema, numeric);
        }
    }

    public static <T> String toJSON(T message, Schema<T> schema, boolean numeric) {
        String string;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ProtostuffUtil.toJSON(baos, message, schema, numeric);
            string = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    ProtostuffUtil.$closeResource(throwable, baos);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new AssertionError("IOException not expected with ByteArrayOutputStream", e);
            }
        }
        ProtostuffUtil.$closeResource(throwable, baos);
        return string;
    }
}

