/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util;

import cdjd.com.dremio.io.ExponentialBackoff;
import cdjd.org.apache.arrow.util.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retryer<T>
implements ExponentialBackoff {
    private static Logger logger = LoggerFactory.getLogger(Retryer.class);
    private Set<Class<? extends Exception>> retryableExceptionClasses = new HashSet<Class<? extends Exception>>();
    private WaitStrategy waitStrategy = WaitStrategy.EXPONENTIAL;
    private int maxRetries = 4;
    private int baseMillis = 250;
    private int maxMillis = 2500;

    private Retryer() {
    }

    public T call(Callable<T> callable) {
        block6: for (int attemptNo = 1; attemptNo <= this.maxRetries; ++attemptNo) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                boolean retryable = this.retryableExceptionClasses.stream().anyMatch(clz -> clz.isInstance(e));
                if (!retryable || attemptNo == this.maxRetries) {
                    throw new OperationFailedAfterRetriesException(e);
                }
                StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
                logger.warn("Retry attempt {} for the failure at {}:{}:{}, Error - {}", attemptNo, caller.getClassName(), caller.getMethodName(), caller.getLineNumber(), e.getMessage());
                switch (this.waitStrategy) {
                    case EXPONENTIAL: {
                        this.backoffWait(attemptNo);
                        continue block6;
                    }
                    case FLAT: {
                        this.flatWait();
                        continue block6;
                    }
                    default: {
                        throw new UnsupportedOperationException("Strategy not implemented: " + this.waitStrategy.name());
                    }
                }
            }
        }
        throw new OperationFailedAfterRetriesException();
    }

    @Override
    public int getBaseMillis() {
        return this.baseMillis;
    }

    @Override
    public int getMaxMillis() {
        return this.maxMillis;
    }

    private void flatWait() {
        this.sleep(this.baseMillis);
    }

    @VisibleForTesting
    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Retryer<T> copy() {
        Retryer<T> copy = new Retryer<T>();
        copy.waitStrategy = this.waitStrategy;
        copy.baseMillis = this.baseMillis;
        copy.maxMillis = this.maxMillis;
        copy.maxRetries = this.maxRetries;
        copy.retryableExceptionClasses.addAll(this.retryableExceptionClasses);
        return copy;
    }

    public static class OperationFailedAfterRetriesException
    extends RuntimeException {
        OperationFailedAfterRetriesException() {
        }

        OperationFailedAfterRetriesException(Exception e) {
            super(e);
        }

        public <T extends Exception> T getWrappedCause(Class<T> clazz, Function<Throwable, T> conversionFunc) {
            return (T)(clazz.isInstance(this.getCause()) ? (Exception)this.getCause() : (Exception)conversionFunc.apply(this.getCause()));
        }
    }

    public static class Builder<T> {
        private Retryer<T> retryer = new Retryer();

        public Builder<T> retryIfExceptionOfType(Class<? extends Exception> clazz) {
            ((Retryer)this.retryer).retryableExceptionClasses.add(clazz);
            return this;
        }

        public Builder<T> setWaitStrategy(WaitStrategy waitStrategy, int baseMillis, int maxMillis) {
            ((Retryer)this.retryer).waitStrategy = waitStrategy;
            ((Retryer)this.retryer).baseMillis = baseMillis;
            ((Retryer)this.retryer).maxMillis = maxMillis;
            return this;
        }

        public Builder<T> setMaxRetries(int maxRetries) {
            ((Retryer)this.retryer).maxRetries = maxRetries;
            return this;
        }

        public Retryer<T> build() {
            return this.retryer;
        }
    }

    public static enum WaitStrategy {
        EXPONENTIAL,
        FLAT;

    }
}

