/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util;

import cdjd.org.apache.arrow.vector.DateMilliVector;
import cdjd.org.apache.arrow.vector.IntervalDayVector;
import cdjd.org.apache.arrow.vector.IntervalYearVector;
import cdjd.org.apache.arrow.vector.TimeMilliVector;
import cdjd.org.apache.arrow.vector.TimeStampMilliVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.holders.NullableDateMilliHolder;
import cdjd.org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import cdjd.org.apache.arrow.vector.holders.NullableIntervalYearHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import cdjd.org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.joda.time.DateTimeZone;
import cdjd.org.joda.time.LocalDateTime;
import cdjd.org.joda.time.Period;

public class DremioGetObject {
    public static Period getPeriodObject(IntervalDayVector vector, int index) {
        return (Period)DremioGetObject.getObject(vector, index);
    }

    public static Period getPeriodObject(IntervalYearVector vector, int index) {
        return (Period)DremioGetObject.getObject(vector, index);
    }

    public static Object getObject(ValueVector vector, int index) {
        Types.MinorType minorType = vector.getMinorType();
        switch (minorType) {
            case DATEMILLI: {
                NullableDateMilliHolder holder = new NullableDateMilliHolder();
                ((DateMilliVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                long millis = holder.value;
                return new LocalDateTime(millis, DateTimeZone.UTC);
            }
            case TIMEMILLI: {
                NullableTimeMilliHolder holder = new NullableTimeMilliHolder();
                ((TimeMilliVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                int millis = holder.value;
                return new LocalDateTime((long)millis, DateTimeZone.UTC);
            }
            case TIMESTAMPMILLI: {
                NullableTimeStampMilliHolder holder = new NullableTimeStampMilliHolder();
                ((TimeStampMilliVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                long millis = holder.value;
                return new LocalDateTime(millis, DateTimeZone.UTC);
            }
            case INTERVALDAY: {
                NullableIntervalDayHolder holder = new NullableIntervalDayHolder();
                ((IntervalDayVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                int days = holder.days;
                int milliseconds = holder.milliseconds;
                Period p = new Period();
                return p.plusDays(days).plusMillis(milliseconds);
            }
            case INTERVALYEAR: {
                NullableIntervalYearHolder holder = new NullableIntervalYearHolder();
                ((IntervalYearVector)vector).get(index, holder);
                if (holder.isSet == 0) {
                    return null;
                }
                int interval = holder.value;
                int years = interval / 12;
                int months = interval % 12;
                Period p = new Period();
                return p.plusYears(years).plusMonths(months);
            }
        }
        return vector.getObject(index);
    }
}

