/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.types;

import cdjd.com.dremio.common.expression.CompleteType;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import java.util.Optional;

public class SchemaUpPromotionRules {
    public static Optional<CompleteType> getResultantType(CompleteType fileType, CompleteType tableType) {
        if (fileType.equals(CompleteType.BIGINT)) {
            return SchemaUpPromotionRules.getResultantTypeForBigIntFileType(tableType);
        }
        if (fileType.equals(CompleteType.FLOAT)) {
            return SchemaUpPromotionRules.getResultantTypeForFloatFileType(tableType);
        }
        if (fileType.equals(CompleteType.DOUBLE)) {
            return SchemaUpPromotionRules.getResultantTypeForDoubleFileType(tableType);
        }
        if (fileType.equals(CompleteType.VARCHAR)) {
            return SchemaUpPromotionRules.getResultantTypeForVarcharFileType(tableType);
        }
        if (fileType.isValidDecimal()) {
            return SchemaUpPromotionRules.getResultantTypeForDecimalFileType(fileType, tableType);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForDecimalFileType(CompleteType fileType, CompleteType tableType) {
        if (tableType.equals(CompleteType.INT) || tableType.equals(CompleteType.BIGINT) || tableType.equals(CompleteType.FLOAT)) {
            ArrowType.Decimal decimal = ArrowType.Decimal.createDecimal(fileType.getPrecision(), fileType.getScale(), null);
            return Optional.of(new CompleteType((ArrowType)decimal, new Field[0]));
        }
        if (tableType.isValidDecimal()) {
            int outputScale = SchemaUpPromotionRules.computeFractional(fileType, tableType);
            int outputPrecision = SchemaUpPromotionRules.computeIntegral(fileType, tableType) + outputScale;
            if (outputPrecision > 38) {
                return SchemaUpPromotionRules.handlePrecisionOverflow(fileType, tableType);
            }
            return Optional.of(new CompleteType((ArrowType)ArrowType.Decimal.createDecimal(outputPrecision, outputScale, null), new Field[0]));
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForVarcharFileType(CompleteType tableType) {
        if (tableType.equals(CompleteType.BIT) || tableType.equals(CompleteType.INT) || tableType.equals(CompleteType.BIGINT) || tableType.equals(CompleteType.FLOAT) || tableType.equals(CompleteType.DOUBLE) || tableType.isValidDecimal()) {
            return Optional.of(CompleteType.VARCHAR);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForDoubleFileType(CompleteType tableType) {
        if (tableType.equals(CompleteType.INT) || tableType.equals(CompleteType.BIGINT) || tableType.equals(CompleteType.FLOAT) || tableType.isValidDecimal()) {
            return Optional.of(CompleteType.DOUBLE);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForFloatFileType(CompleteType tableType) {
        if (tableType.equals(CompleteType.INT) || tableType.equals(CompleteType.BIGINT)) {
            return Optional.of(CompleteType.DOUBLE);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForBigIntFileType(CompleteType tableType) {
        if (tableType.equals(CompleteType.INT)) {
            return Optional.of(CompleteType.BIGINT);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> handlePrecisionOverflow(CompleteType fileType, CompleteType tableType) {
        int outputPrecision = 38;
        int outputScale = outputPrecision - SchemaUpPromotionRules.computeIntegral(fileType, tableType);
        return Optional.of(new CompleteType((ArrowType)ArrowType.Decimal.createDecimal(outputPrecision, outputScale, null), new Field[0]));
    }

    private static int computeIntegral(CompleteType fileType, CompleteType tableType) {
        return Math.max(fileType.getPrecision() - fileType.getScale(), tableType.getPrecision() - tableType.getScale());
    }

    private static int computeFractional(CompleteType fileType, CompleteType tableType) {
        return Math.max(fileType.getScale(), tableType.getScale());
    }
}

