/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.serde;

import cdjd.com.fasterxml.jackson.core.JsonGenerationException;
import cdjd.com.fasterxml.jackson.databind.ObjectMapper;
import cdjd.com.fasterxml.jackson.databind.ObjectReader;
import cdjd.com.fasterxml.jackson.databind.SerializationFeature;
import cdjd.com.google.common.io.ByteSource;
import cdjd.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

public final class ProtobufByteStringSerDe {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteString writeValue(ObjectMapper mapper, Object value, Codec codec) throws JsonGenerationException {
        ByteString.Output output = ByteString.newOutput();
        try (OutputStream os = codec.compress(output);){
            mapper.writer().without(SerializationFeature.INDENT_OUTPUT).writeValue(os, value);
        }
        catch (IOException e) {
            throw new JsonGenerationException(e, null);
        }
        return output.toByteString();
    }

    public static <T> T readValue(ObjectReader reader, final ByteString byteString, final Codec codec, Logger logger) throws IOException {
        if (logger.isTraceEnabled()) {
            ByteSource bs = new ByteSource(){

                @Override
                public InputStream openStream() throws IOException {
                    return codec.decompress(byteString.newInput());
                }
            };
            String value = bs.asCharSource(StandardCharsets.UTF_8).read();
            logger.trace("Attempting to read {}", (Object)value);
        }
        try (InputStream is = codec.decompress(byteString.newInput());){
            Object t = reader.readValue(is);
            return t;
        }
    }

    private ProtobufByteStringSerDe() {
    }

    public static interface Codec {
        public static final Codec NONE = new Codec(){

            @Override
            public OutputStream compress(OutputStream output) {
                return output;
            }

            @Override
            public InputStream decompress(InputStream input) {
                return input;
            }
        };

        public OutputStream compress(OutputStream var1) throws IOException;

        public InputStream decompress(InputStream var1) throws IOException;
    }
}

