/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.serde;

import cdjd.com.fasterxml.jackson.core.JsonParser;
import cdjd.com.fasterxml.jackson.core.JsonProcessingException;
import cdjd.com.fasterxml.jackson.core.type.TypeReference;
import cdjd.com.fasterxml.jackson.databind.DeserializationContext;
import cdjd.com.fasterxml.jackson.databind.JsonNode;
import cdjd.com.fasterxml.jackson.databind.ObjectMapper;
import cdjd.com.fasterxml.jackson.databind.ObjectReader;
import cdjd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import cdjd.com.fasterxml.jackson.databind.module.SimpleModule;
import cdjd.com.fasterxml.jackson.databind.node.NullNode;
import cdjd.com.google.common.base.Preconditions;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.types.pojo.Schema;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class BackwardCompatibleSchemaDe
extends StdDeserializer<Schema> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final SimpleModule module = new SimpleModule();
    private static final ObjectReader fieldsReader;

    protected BackwardCompatibleSchemaDe() {
        this((Class<?>)null);
    }

    protected BackwardCompatibleSchemaDe(Class<?> vc) {
        super(vc);
    }

    public static Schema fromJSON(String json) throws IOException {
        return mapper.readValue(Preconditions.checkNotNull(json), Schema.class);
    }

    @Override
    public Schema deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode metadataNode = node.get("metadata");
        Map metadata = mapper.convertValue((Object)metadataNode, Map.class);
        JsonNode fieldsNode = node.get("fields");
        Iterable fields = (Iterable)fieldsReader.readValue(fieldsNode);
        return new Schema((Iterable<Field>)fields, metadata);
    }

    static {
        module.addDeserializer(Schema.class, new BackwardCompatibleSchemaDe());
        module.addDeserializer(Field.class, new BackwardCompatibleFieldDeserializer());
        mapper.registerModule(module);
        fieldsReader = mapper.readerFor(new TypeReference<List<Field>>(){});
    }

    public static class BackwardCompatibleFieldDeserializer
    extends StdDeserializer<Field> {
        public BackwardCompatibleFieldDeserializer() {
            this((Class<?>)null);
        }

        public BackwardCompatibleFieldDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public Field deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            JsonNode nameNode = node.get("name");
            String name = nameNode instanceof NullNode ? null : nameNode.asText();
            boolean nullable = node.get("nullable").asBoolean();
            JsonNode arrowTypeNode = node.get("type");
            ArrowType arrowType = mapper.convertValue((Object)arrowTypeNode, ArrowType.class);
            JsonNode dictionaryNode = node.get("dictionary");
            DictionaryEncoding dictionary = mapper.convertValue((Object)dictionaryNode, DictionaryEncoding.class);
            JsonNode childrenNode = node.get("children");
            List children = (List)fieldsReader.readValue(childrenNode);
            JsonNode metadataNode = node.get("metadata");
            Map metadata = mapper.convertValue((Object)metadataNode, Map.class);
            FieldType fieldType = new FieldType(nullable, arrowType, dictionary, metadata);
            return new Field(name, fieldType, children);
        }
    }
}

