/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.exceptions;

import cdjd.com.dremio.common.exceptions.UserException;
import cdjd.com.dremio.exec.proto.UserBitShared;
import java.util.List;

public class UserRemoteException
extends UserException {
    private final UserBitShared.DremioPBError error;

    private UserRemoteException(UserBitShared.DremioPBError error) {
        super(error.getErrorType(), "Dremio Remote Exception", null, error.getTypeSpecificContext());
        this.error = error;
    }

    @Override
    public String getMessage() {
        return this.error.getMessage();
    }

    @Override
    public String getOriginalMessage() {
        return this.error.getOriginalMessage();
    }

    @Override
    public String getVerboseMessage() {
        return this.getVerboseMessage(true);
    }

    @Override
    public String getVerboseMessage(boolean includeErrorIdAndIdentity) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.error.getMessage());
        if (this.error.getContextCount() > 0) {
            sb.append("\n\n");
            for (String context : this.error.getContextList()) {
                sb.append(context).append("\n");
            }
        }
        if (this.error.hasException()) {
            sb.append("\n");
            for (UserBitShared.StackTraceElementWrapper stackLine : this.error.getException().getStackTraceList()) {
                sb.append(stackLine.getClassName()).append("(").append(stackLine.getFileName()).append(":").append(stackLine.getLineNumber()).append(")\n");
            }
        }
        return sb.toString();
    }

    @Override
    public UserBitShared.DremioPBError getOrCreatePBError(boolean verbose) {
        return this.error;
    }

    @Override
    public List<String> getContextStrings() {
        return this.error.getContextList();
    }

    public static UserRemoteException create(UserBitShared.DremioPBError error) {
        return new UserRemoteException(error);
    }
}

