/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.exceptions;

import cdjd.com.dremio.common.exceptions.UserException;
import org.slf4j.Logger;

public final class FieldSizeLimitExceptionHelper {
    private FieldSizeLimitExceptionHelper() {
    }

    public static void checkSizeLimit(int size, int maxSize, Logger logger) {
        if (size > maxSize) {
            throw FieldSizeLimitExceptionHelper.createFieldSizeLimitException(size, maxSize, logger);
        }
    }

    public static void checkSizeLimit(int size, int maxSize, int fieldIndex, Logger logger) {
        if (size > maxSize) {
            throw FieldSizeLimitExceptionHelper.createFieldSizeLimitException(size, maxSize, fieldIndex, logger);
        }
    }

    public static void checkSizeLimit(int size, int maxSize, String fieldName, Logger logger) {
        if (size > maxSize) {
            throw FieldSizeLimitExceptionHelper.createFieldSizeLimitException(size, maxSize, fieldName, logger);
        }
    }

    public static UserException createListChildrenLimitException(String fieldName, long maxSize) {
        return UserException.unsupportedError().message("List field '%s' exceeded the maximum number of elements %d", fieldName, maxSize).addContext("limit", maxSize).build();
    }

    public static UserException createFieldSizeLimitException(int size, int maxSize, Logger logger) {
        return UserException.unsupportedError().message("Field exceeds the size limit of %d bytes.", maxSize).addContext("size", size).addContext("limit", maxSize).build(logger);
    }

    public static UserException createFieldSizeLimitException(int size, int maxSize) {
        return UserException.unsupportedError().message("Field exceeds the size limit of %d bytes.", maxSize).addContext("size", size).addContext("limit", maxSize).build();
    }

    public static UserException createFieldSizeLimitException(int size, int maxSize, int fieldIndex, Logger logger) {
        return UserException.unsupportedError().message("Field with index %d exceeds the size limit of %d bytes.", fieldIndex, maxSize).addContext("fieldIndex", fieldIndex).addContext("size", size).addContext("limit", maxSize).build(logger);
    }

    public static UserException createFieldSizeLimitException(int size, int maxSize, String fieldName, Logger logger) {
        return UserException.unsupportedError().message("Field '%s' exceeds the size limit of %d bytes.", fieldName, maxSize).addContext("fieldName", fieldName).addContext("size", size).addContext("limit", maxSize).build(logger);
    }
}

