/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.carrotsearch.hppc;

import cdjd.com.carrotsearch.hppc.BitMixer;
import cdjd.com.carrotsearch.hppc.HashOrderMixing;
import cdjd.com.carrotsearch.hppc.ObjectDoubleHashMap;

public class ObjectDoubleScatterMap<KType>
extends ObjectDoubleHashMap<KType> {
    public ObjectDoubleScatterMap() {
        this(4);
    }

    public ObjectDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectDoubleScatterMap<KType> from(KType[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectDoubleScatterMap<KType> map = new ObjectDoubleScatterMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

