/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.carrotsearch.hppc;

import cdjd.com.carrotsearch.hppc.BitMixer;
import cdjd.com.carrotsearch.hppc.CharFloatHashMap;
import cdjd.com.carrotsearch.hppc.HashOrderMixing;

public class CharFloatScatterMap
extends CharFloatHashMap {
    public CharFloatScatterMap() {
        this(4);
    }

    public CharFloatScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharFloatScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharFloatScatterMap from(char[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharFloatScatterMap map = new CharFloatScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

