/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.carrotsearch.hppc;

import cdjd.com.carrotsearch.hppc.AbstractCharCollection;
import cdjd.com.carrotsearch.hppc.AbstractDoubleCollection;
import cdjd.com.carrotsearch.hppc.AbstractIterator;
import cdjd.com.carrotsearch.hppc.BitMixer;
import cdjd.com.carrotsearch.hppc.BufferAllocationException;
import cdjd.com.carrotsearch.hppc.CharBufferVisualizer;
import cdjd.com.carrotsearch.hppc.CharContainer;
import cdjd.com.carrotsearch.hppc.CharDoubleAssociativeContainer;
import cdjd.com.carrotsearch.hppc.CharDoubleMap;
import cdjd.com.carrotsearch.hppc.CharLookupContainer;
import cdjd.com.carrotsearch.hppc.DoubleCollection;
import cdjd.com.carrotsearch.hppc.HashContainers;
import cdjd.com.carrotsearch.hppc.HashOrderMixing;
import cdjd.com.carrotsearch.hppc.HashOrderMixingStrategy;
import cdjd.com.carrotsearch.hppc.Preallocable;
import cdjd.com.carrotsearch.hppc.cursors.CharCursor;
import cdjd.com.carrotsearch.hppc.cursors.CharDoubleCursor;
import cdjd.com.carrotsearch.hppc.cursors.DoubleCursor;
import cdjd.com.carrotsearch.hppc.predicates.CharDoublePredicate;
import cdjd.com.carrotsearch.hppc.predicates.CharPredicate;
import cdjd.com.carrotsearch.hppc.predicates.DoublePredicate;
import cdjd.com.carrotsearch.hppc.procedures.CharDoubleProcedure;
import cdjd.com.carrotsearch.hppc.procedures.CharProcedure;
import cdjd.com.carrotsearch.hppc.procedures.DoubleProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharDoubleHashMap
implements CharDoubleMap,
Preallocable,
Cloneable {
    public char[] keys;
    public double[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public CharDoubleHashMap() {
        this(4);
    }

    public CharDoubleHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharDoubleHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public CharDoubleHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public CharDoubleHashMap(CharDoubleAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public double put(char key, double value) {
        char existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == '\u0000') {
            this.hasEmptyKey = true;
            double previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                double previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0.0;
    }

    @Override
    public int putAll(CharDoubleAssociativeContainer container) {
        int count = this.size();
        for (CharDoubleCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends CharDoubleCursor> iterable) {
        int count = this.size();
        for (CharDoubleCursor charDoubleCursor : iterable) {
            this.put(charDoubleCursor.key, charDoubleCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(char key, double value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(char key, double putValue, double incrementValue) {
        assert (this.assigned < this.mask + 1);
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public double addTo(char key, double incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public double remove(char key) {
        char existing;
        int mask = this.mask;
        if (key == '\u0000') {
            this.hasEmptyKey = false;
            double previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0.0;
            return previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                double previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0.0;
    }

    @Override
    public int removeAll(CharContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof CharLookupContainer) {
            if (this.hasEmptyKey && other.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0;
            }
            char[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                char existing = keys[slot];
                if (existing != '\u0000' && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (CharCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(CharDoublePredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply('\u0000', this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0.0;
        }
        char[] keys = this.keys;
        double[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            char existing = keys[slot];
            if (existing != '\u0000' && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0;
        }
        char[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            char existing = keys[slot];
            if (existing != '\u0000' && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public double get(char key) {
        char existing;
        if (key == '\u0000') {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0.0;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0.0;
    }

    @Override
    public double getOrDefault(char key, double defaultValue) {
        char existing;
        if (key == '\u0000') {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(char key) {
        char existing;
        if (key == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(char key) {
        char existing;
        int mask = this.mask;
        if (key == '\u0000') {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public double indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public double indexReplace(int index, double newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        double previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, char key, double value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == '\u0000') {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == '\u0000');
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h2 = this.hasEmptyKey ? -559038737 : 0;
        for (CharDoubleCursor c : this) {
            h2 += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h2;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((CharDoubleHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(CharDoubleHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (CharDoubleCursor c : other) {
            char key = c.key;
            if (this.containsKey(key) && Double.doubleToLongBits(this.get(key)) == Double.doubleToLongBits(c.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            char[] prevKeys = this.keys;
            double[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<CharDoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharDoubleProcedure> T forEach(T procedure) {
        char[] keys = this.keys;
        double[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply('\u0000', values[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (keys[slot] == '\u0000') continue;
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends CharDoublePredicate> T forEach(T predicate) {
        char[] keys = this.keys;
        double[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply('\u0000', values[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (keys[slot] == '\u0000' || predicate.apply(keys[slot], values[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public DoubleCollection values() {
        return new ValuesContainer();
    }

    public CharDoubleHashMap clone() {
        try {
            CharDoubleHashMap cloned = (CharDoubleHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (double[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharDoubleCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static CharDoubleHashMap from(char[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharDoubleHashMap map = new CharDoubleHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(char key) {
        assert (key != '\u0000');
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(char[] fromKeys, double[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        char[] keys = this.keys;
        double[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            char existing = fromKeys[from];
            if (existing == '\u0000') continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        char[] prevKeys = this.keys;
        double[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new char[arraySize + emptyElementSlot];
            this.values = new double[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, char pendingKey, double pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == '\u0000' && pendingKey != '\u0000');
        char[] prevKeys = this.keys;
        double[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        char existing;
        char[] keys = this.keys;
        double[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != '\u0000') {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        values[gapSlot] = 0.0;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = CharDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (CharDoubleHashMap.this.keys[this.slot] != '\u0000') {
                        this.cursor.index = this.slot;
                        this.cursor.value = CharDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && CharDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = CharDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final CharDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = CharDoubleHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            for (CharDoubleCursor c : this.owner) {
                if (Double.doubleToLongBits(c.value) != Double.doubleToLongBits(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            for (CharDoubleCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            for (CharDoubleCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final double e) {
            return this.owner.removeAll(new CharDoublePredicate(){

                @Override
                public boolean apply(char key, double value) {
                    return Double.doubleToLongBits(value) == Double.doubleToLongBits(e);
                }
            });
        }

        @Override
        public int removeAll(final DoublePredicate predicate) {
            return this.owner.removeAll(new CharDoublePredicate(){

                @Override
                public boolean apply(char key, double value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = CharDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    char existing = CharDoubleHashMap.this.keys[this.slot];
                    if (existing != '\u0000') {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && CharDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = '\u0000';
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharDoubleHashMap owner;

        public KeysContainer() {
            this.owner = CharDoubleHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(final T procedure) {
            this.owner.forEach(new CharDoubleProcedure(){

                @Override
                public void apply(char key, double value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(final T predicate) {
            this.owner.forEach(new CharDoublePredicate(){

                @Override
                public boolean apply(char key, double value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(char e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<CharDoubleCursor> {
        private final CharDoubleCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharDoubleCursor();
        }

        @Override
        protected CharDoubleCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    char existing = CharDoubleHashMap.this.keys[this.slot];
                    if (existing != '\u0000') {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = CharDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && CharDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = '\u0000';
                this.cursor.value = CharDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharDoubleCursor)this.done();
        }
    }
}

