# Copyright (c) 2020 by Henry Stern
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import functools

import requests


class SpypointException(Exception):
    pass


class NotAuthorized(SpypointException):
    pass


class Forbidden(SpypointException):
    pass


class NotFound(SpypointException):
    pass


def catches(f):
    @functools.wraps(f)
    def g(*args, **kwargs):
        try:
            return f(*args, **kwargs)
        except requests.RequestException as e:
            if e.response.status_code == 401:
                raise NotAuthorized() from e
            elif e.response.status_code == 403:
                raise Forbidden() from e
            elif e.response.status_code == 404:
                raise NotFound() from e
            raise SpypointException() from e
    return g
